/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.serialization.util;

import com.amazonaws.services.lambda.runtime.serialization.util.Functions;
import com.amazonaws.services.lambda.runtime.serialization.util.LambdaByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static Class<?> copyClass(Class<?> clazz, ClassLoader cl) {
        try {
            return cl.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LambdaByteArrayOutputStream stream;
            int chunkSize = 1024;
            String resourceName = clazz.getName().replace('.', '/') + ".class";
            try (InputStream input = clazz.getClassLoader().getResourceAsStream(resourceName);){
                int initial = Math.max(1024, input.available());
                stream = new LambdaByteArrayOutputStream(initial);
                stream.readAll(input);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try {
                Functions.R5<Class, ClassLoader, String, byte[], Integer, Integer> defineClassMethod = ReflectUtil.loadInstanceR4(ClassLoader.class, "defineClass", true, Class.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                Class result = defineClassMethod.call(cl, clazz.getName(), stream.getRawBuf(), 0, stream.getValidByteCount());
                Functions.V2<ClassLoader, Class> resolveClass = ReflectUtil.loadInstanceV1(ClassLoader.class, "resolveClass", true, Class.class);
                resolveClass.call(cl, result);
                return result;
            }
            catch (ClassFormatError | SecurityException e) {
                throw new ReflectException(e);
            }
        }
    }

    public static Class<?> loadClass(ClassLoader cl, String name) {
        try {
            return Class.forName(name, true, cl);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new ReflectException(e);
        }
    }

    private static <T> T newInstance(Constructor<? extends T> constructor, Object ... params) {
        try {
            return constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtil.getRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Class<?> componentRaw = ReflectUtil.getRawClass(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(componentRaw, 0).getClass();
        }
        if (type instanceof TypeVariable) {
            throw new ReflectException("type variables not supported");
        }
        throw new ReflectException("unsupport type: " + type.getClass().getName());
    }

    public static Functions.R1<Object, Object> makeCaster(Type type) {
        return ReflectUtil.makeCaster(ReflectUtil.getRawClass(type));
    }

    private static <T> Functions.R1<T, Object> boxCaster(final Class<? extends T> clazz) {
        return new Functions.R1<T, Object>(){

            @Override
            public T call(Object o) {
                return clazz.cast(o);
            }
        };
    }

    public static <T> Functions.R1<T, Object> makeCaster(Class<? extends T> clazz) {
        if (Long.TYPE.equals(clazz)) {
            return ReflectUtil.boxCaster(Long.class);
        }
        if (Double.TYPE.equals(clazz)) {
            return ReflectUtil.boxCaster(Double.class);
        }
        if (Float.TYPE.equals(clazz)) {
            return ReflectUtil.boxCaster(Float.class);
        }
        if (Integer.TYPE.equals(clazz)) {
            return ReflectUtil.boxCaster(Integer.class);
        }
        if (Short.TYPE.equals(clazz)) {
            return ReflectUtil.boxCaster(Short.class);
        }
        if (Character.TYPE.equals(clazz)) {
            return ReflectUtil.boxCaster(Character.class);
        }
        if (Byte.TYPE.equals(clazz)) {
            return ReflectUtil.boxCaster(Byte.class);
        }
        if (Boolean.TYPE.equals(clazz)) {
            return ReflectUtil.boxCaster(Boolean.class);
        }
        return ReflectUtil.boxCaster(clazz);
    }

    private static <T> T invoke(Method method, Object instance, Class<? extends T> rType, Object ... params) {
        Functions.R1<T, Object> caster = ReflectUtil.makeCaster(rType);
        try {
            Object result = method.invoke(instance, params);
            if (rType.equals(Void.TYPE)) {
                return null;
            }
            return caster.call(result);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    private static Method lookupMethod(Class<?> clazz, String name, Class<?> ... pTypes) {
        try {
            return clazz.getDeclaredMethod(name, pTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(name, pTypes);
            }
            catch (NoSuchMethodException | SecurityException e2) {
                throw new ReflectException(e2);
            }
        }
    }

    private static Method getDeclaredMethod(Class<?> clazz, String name, boolean isStatic, boolean setAccessible, Class<?> rType, Class<?> ... pTypes) {
        Method method = ReflectUtil.lookupMethod(clazz, name, pTypes);
        if (!rType.equals(Void.TYPE) && !rType.isAssignableFrom(method.getReturnType())) {
            throw new ReflectException("Class=" + clazz.getName() + " method=" + name + " type " + method.getReturnType().getName() + " not assignment-compatible with " + rType.getName());
        }
        int mods = method.getModifiers();
        if (Modifier.isStatic(mods) != isStatic) {
            throw new ReflectException("Class=" + clazz.getName() + " method=" + name + " expected isStatic=" + isStatic);
        }
        if (setAccessible) {
            method.setAccessible(true);
        }
        return method;
    }

    private static <T> Constructor<? extends T> getDeclaredConstructor(Class<? extends T> clazz, boolean setAccessible, Class<?> ... pTypes) {
        Constructor<T> constructor;
        try {
            constructor = clazz.getDeclaredConstructor(pTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new ReflectException(e);
        }
        if (setAccessible) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static <C, R> Functions.R1<R, C> loadInstanceR0(Class<? super C> clazz, String name, boolean setAccessible, final Class<? extends R> rType) {
        final Method method = ReflectUtil.getDeclaredMethod(clazz, name, false, setAccessible, rType, new Class[0]);
        return new Functions.R1<R, C>(){

            @Override
            public R call(C instance) {
                return ReflectUtil.invoke(method, instance, rType, new Object[0]);
            }
        };
    }

    public static <A1, A2, A3, A4, C, R> Functions.R5<R, C, A1, A2, A3, A4> loadInstanceR4(Class<? super C> clazz, String name, boolean setAccessible, final Class<? extends R> rType, Class<? super A1> a1Type, Class<? super A2> a2Type, Class<? super A3> a3Type, Class<? super A4> a4Type) {
        final Method method = ReflectUtil.getDeclaredMethod(clazz, name, false, setAccessible, rType, a1Type, a2Type, a3Type, a4Type);
        return new Functions.R5<R, C, A1, A2, A3, A4>(){

            @Override
            public R call(C instance, A1 a1, A2 a2, A3 a3, A4 a4) {
                return ReflectUtil.invoke(method, instance, rType, new Object[]{a1, a2, a3, a4});
            }
        };
    }

    public static <A1, C> Functions.V2<C, A1> loadInstanceV1(Class<? super C> clazz, String name, boolean setAccessible, Class<? super A1> a1Type) {
        final Method method = ReflectUtil.getDeclaredMethod(clazz, name, false, setAccessible, Void.TYPE, a1Type);
        return new Functions.V2<C, A1>(){

            @Override
            public void call(C instance, A1 a1) {
                ReflectUtil.invoke(method, instance, Void.TYPE, new Object[]{a1});
            }
        };
    }

    public static <C, R> Functions.R0<R> bindInstanceR0(final C instance, String name, boolean setAccessible, final Class<? extends R> rType) {
        final Method method = ReflectUtil.getDeclaredMethod(instance.getClass(), name, false, setAccessible, rType, new Class[0]);
        return new Functions.R0<R>(){

            @Override
            public R call() {
                return ReflectUtil.invoke(method, instance, rType, new Object[0]);
            }
        };
    }

    public static <A1, C, R> Functions.R1<R, A1> bindInstanceR1(final C instance, String name, boolean setAccessible, final Class<? extends R> rType, Class<? super A1> a1Type) {
        final Method method = ReflectUtil.getDeclaredMethod(instance.getClass(), name, false, setAccessible, rType, a1Type);
        return new Functions.R1<R, A1>(){

            @Override
            public R call(A1 a1) {
                return ReflectUtil.invoke(method, instance, rType, new Object[]{a1});
            }
        };
    }

    public static <A1, C> Functions.V1<A1> bindInstanceV1(final C instance, String name, boolean setAccessible, Class<? super A1> a1Type) {
        final Method method = ReflectUtil.getDeclaredMethod(instance.getClass(), name, false, setAccessible, Void.TYPE, a1Type);
        return new Functions.V1<A1>(){

            @Override
            public void call(A1 a1) {
                ReflectUtil.invoke(method, instance, Void.TYPE, new Object[]{a1});
            }
        };
    }

    public static <A1, A2, C> Functions.V2<A1, A2> bindInstanceV2(final C instance, String name, boolean setAccessible, Class<? super A1> a1Type, Class<? super A2> a2Type) {
        final Method method = ReflectUtil.getDeclaredMethod(instance.getClass(), name, false, setAccessible, Void.TYPE, a1Type, a2Type);
        return new Functions.V2<A1, A2>(){

            @Override
            public void call(A1 a1, A2 a2) {
                ReflectUtil.invoke(method, instance, Void.TYPE, new Object[]{a1, a2});
            }
        };
    }

    public static <R> Functions.R0<R> loadStaticR0(Class<?> clazz, String name, boolean setAccessible, final Class<? extends R> rType) {
        final Method method = ReflectUtil.getDeclaredMethod(clazz, name, true, setAccessible, rType, new Class[0]);
        return new Functions.R0<R>(){

            @Override
            public R call() {
                return ReflectUtil.invoke(method, null, rType, new Object[0]);
            }
        };
    }

    public static <A1, R> Functions.R1<R, A1> loadStaticR1(Class<?> clazz, String name, boolean setAccessible, final Class<? extends R> rType, Class<? super A1> a1Type) {
        final Method method = ReflectUtil.getDeclaredMethod(clazz, name, true, setAccessible, rType, a1Type);
        return new Functions.R1<R, A1>(){

            @Override
            public R call(A1 a1) {
                return ReflectUtil.invoke(method, null, rType, new Object[]{a1});
            }
        };
    }

    public static <A1, A2> Functions.V2<A1, A2> loadStaticV2(Class<?> clazz, String name, boolean setAccessible, Class<? super A1> a1Type, Class<? super A2> a2Type) {
        final Method method = ReflectUtil.getDeclaredMethod(clazz, name, true, setAccessible, Void.TYPE, a1Type, a2Type);
        return new Functions.V2<A1, A2>(){

            @Override
            public void call(A1 a1, A2 a2) {
                ReflectUtil.invoke(method, null, Void.TYPE, new Object[]{a1, a2});
            }
        };
    }

    public static <C> Functions.R0<C> loadConstructor0(Class<? extends C> clazz, boolean setAccessible) {
        final Constructor<? extends C> constructor = ReflectUtil.getDeclaredConstructor(clazz, setAccessible, new Class[0]);
        return new Functions.R0<C>(){

            @Override
            public C call() {
                return ReflectUtil.newInstance(constructor, new Object[0]);
            }
        };
    }

    public static <A1, C> Functions.R1<C, A1> loadConstructor1(Class<? extends C> clazz, boolean setAccessible, Class<? super A1> a1Type) {
        final Constructor<? extends C> constructor = ReflectUtil.getDeclaredConstructor(clazz, setAccessible, a1Type);
        return new Functions.R1<C, A1>(){

            @Override
            public C call(A1 a1) {
                return ReflectUtil.newInstance(constructor, new Object[]{a1});
            }
        };
    }

    public static <A1, A2, C> Functions.R2<C, A1, A2> loadConstructor2(Class<? extends C> clazz, boolean setAccessible, Class<? super A1> a1Type, Class<? super A2> a2Type) {
        final Constructor<? extends C> constructor = ReflectUtil.getDeclaredConstructor(clazz, setAccessible, a1Type, a2Type);
        return new Functions.R2<C, A1, A2>(){

            @Override
            public C call(A1 a1, A2 a2) {
                return ReflectUtil.newInstance(constructor, new Object[]{a1, a2});
            }
        };
    }

    public static <C, A1, A2, A3> Functions.R3<C, A1, A2, A3> loadConstuctor3(Class<? extends C> clazz, boolean setAccessible, Class<? super A1> a1Type, Class<? super A2> a2Type, Class<? super A3> a3Type) {
        final Constructor<? extends C> constructor = ReflectUtil.getDeclaredConstructor(clazz, setAccessible, a1Type, a2Type, a3Type);
        return new Functions.R3<C, A1, A2, A3>(){

            @Override
            public C call(A1 a1, A2 a2, A3 a3) {
                return ReflectUtil.newInstance(constructor, new Object[]{a1, a2, a3});
            }
        };
    }

    public static <C, A1, A2, A3, A4> Functions.R4<C, A1, A2, A3, A4> loadConstuctor4(Class<? extends C> clazz, boolean setAccessible, Class<? super A1> a1Type, Class<? super A2> a2Type, Class<? super A3> a3Type, Class<? super A4> a4Type) {
        final Constructor<? extends C> constructor = ReflectUtil.getDeclaredConstructor(clazz, setAccessible, a1Type, a2Type, a3Type, a4Type);
        return new Functions.R4<C, A1, A2, A3, A4>(){

            @Override
            public C call(A1 a1, A2 a2, A3 a3, A4 a4) {
                return ReflectUtil.newInstance(constructor, new Object[]{a1, a2, a3, a4});
            }
        };
    }

    public static <C, A1, A2, A3, A4, A5> Functions.R5<C, A1, A2, A3, A4, A5> loadConstuctor5(Class<? extends C> clazz, boolean setAccessible, Class<? super A1> a1Type, Class<? super A2> a2Type, Class<? super A3> a3Type, Class<? super A4> a4Type, Class<? super A5> a5Type) {
        final Constructor<? extends C> constructor = ReflectUtil.getDeclaredConstructor(clazz, setAccessible, a1Type, a2Type, a3Type, a4Type, a5Type);
        return new Functions.R5<C, A1, A2, A3, A4, A5>(){

            @Override
            public C call(A1 a1, A2 a2, A3 a3, A4 a4, A5 a5) {
                return ReflectUtil.newInstance(constructor, new Object[]{a1, a2, a3, a4, a5});
            }
        };
    }

    public static <C, A1, A2, A3, A4, A5, A6, A7, A8, A9> Functions.R9<C, A1, A2, A3, A4, A5, A6, A7, A8, A9> loadConstuctor9(Class<? extends C> clazz, boolean setAccessible, Class<? super A1> a1Type, Class<? super A2> a2Type, Class<? super A3> a3Type, Class<? super A4> a4Type, Class<? super A5> a5Type, Class<? super A6> a6Type, Class<? super A7> a7Type, Class<? super A8> a8Type, Class<? super A9> a9type) {
        final Constructor<? extends C> constructor = ReflectUtil.getDeclaredConstructor(clazz, setAccessible, a1Type, a2Type, a3Type, a4Type, a5Type, a6Type, a7Type, a8Type, a9type);
        return new Functions.R9<C, A1, A2, A3, A4, A5, A6, A7, A8, A9>(){

            @Override
            public C call(A1 a1, A2 a2, A3 a3, A4 a4, A5 a5, A6 a6, A7 a7, A8 a8, A9 a9) {
                return ReflectUtil.newInstance(constructor, new Object[]{a1, a2, a3, a4, a5, a6, a7, a8, a9});
            }
        };
    }

    public static <T> T getStaticField(Class<?> clazz, String name, Class<? extends T> type) {
        Functions.R1<T, Object> caster = ReflectUtil.makeCaster(type);
        try {
            return caster.call(clazz.getField(name).get(null));
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new ReflectException(e);
        }
    }

    public static void setStaticField(Class<?> clazz, String name, boolean setAccessible, Object value) {
        try {
            Field field = clazz.getDeclaredField(name);
            if (setAccessible) {
                field.setAccessible(true);
            }
            field.set(null, value);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new ReflectException(e);
        }
    }

    public static class ReflectException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ReflectException() {
        }

        public ReflectException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public ReflectException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReflectException(String message) {
            super(message);
        }

        public ReflectException(Throwable cause) {
            super(cause);
        }
    }
}

