/*
 * Copyright 2010-2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonServiceException;

/**
 * <p>
 * The quota for HSM client certificates has been reached. For
 * information about increasing your quota, go to
 * <a href="http://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html"> Limits in Amazon Redshift </a>
 * in the <i>Amazon Redshift Management Guide</i> .
 * 
 * </p>
 */        
public class HsmClientCertificateQuotaExceededException extends AmazonServiceException {
    private static final long serialVersionUID = 1L;
    
    /**
     * Constructs a new HsmClientCertificateQuotaExceededException with the specified error
     * message.
     * 
     * @param message Describes the error encountered.
     */
    public HsmClientCertificateQuotaExceededException(String message) {
        super(message);
    }
    
}
    