/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.PlacementStrategy;
import com.amazonaws.services.ec2.model.transform.CreatePlacementGroupRequestMarshaller;
import java.io.Serializable;

public class CreatePlacementGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<CreatePlacementGroupRequest> {
    private String groupName;
    private String strategy;

    public CreatePlacementGroupRequest() {
    }

    public CreatePlacementGroupRequest(String groupName, String strategy) {
        this.setGroupName(groupName);
        this.setStrategy(strategy);
    }

    public CreatePlacementGroupRequest(String groupName, PlacementStrategy strategy) {
        this.groupName = groupName;
        this.strategy = strategy.toString();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public CreatePlacementGroupRequest withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public CreatePlacementGroupRequest withStrategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    public void setStrategy(PlacementStrategy strategy) {
        this.strategy = strategy.toString();
    }

    public CreatePlacementGroupRequest withStrategy(PlacementStrategy strategy) {
        this.strategy = strategy.toString();
        return this;
    }

    @Override
    public Request<CreatePlacementGroupRequest> getDryRunRequest() {
        Request<CreatePlacementGroupRequest> request = new CreatePlacementGroupRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupName() != null) {
            sb.append("GroupName: " + this.getGroupName() + ",");
        }
        if (this.getStrategy() != null) {
            sb.append("Strategy: " + this.getStrategy());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getStrategy() == null ? 0 : this.getStrategy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlacementGroupRequest)) {
            return false;
        }
        CreatePlacementGroupRequest other = (CreatePlacementGroupRequest)obj;
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getStrategy() == null ^ this.getStrategy() == null) {
            return false;
        }
        return other.getStrategy() == null || other.getStrategy().equals(this.getStrategy());
    }
}

