/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateRecordsRequestMarshaller
implements Marshaller<Request<UpdateRecordsRequest>, UpdateRecordsRequest> {
    @Override
    public Request<UpdateRecordsRequest> marshall(UpdateRecordsRequest updateRecordsRequest) {
        if (updateRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateRecordsRequest> request = new DefaultRequest<UpdateRecordsRequest>(updateRecordsRequest, "AmazonCognitoSync");
        String target = "AWSCognitoSyncService.UpdateRecords";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (updateRecordsRequest.getClientContext() != null) {
            request.addHeader("x-amz-Client-Context", StringUtils.fromString(updateRecordsRequest.getClientContext()));
        }
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", updateRecordsRequest.getIdentityPoolId() == null ? "" : StringUtils.fromString(updateRecordsRequest.getIdentityPoolId()));
        uriResourcePath = uriResourcePath.replace("{IdentityId}", updateRecordsRequest.getIdentityId() == null ? "" : StringUtils.fromString(updateRecordsRequest.getIdentityId()));
        uriResourcePath = uriResourcePath.replace("{DatasetName}", updateRecordsRequest.getDatasetName() == null ? "" : StringUtils.fromString(updateRecordsRequest.getDatasetName()));
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag recordPatchesList = (ListWithAutoConstructFlag)updateRecordsRequest.getRecordPatches();
            if (!(recordPatchesList == null || recordPatchesList.isAutoConstruct() && recordPatchesList.isEmpty())) {
                jsonWriter.key("RecordPatches");
                jsonWriter.array();
                for (RecordPatch recordPatchesListValue : recordPatchesList) {
                    if (recordPatchesListValue == null) continue;
                    jsonWriter.object();
                    if (recordPatchesListValue.getOp() != null) {
                        jsonWriter.key("Op").value(recordPatchesListValue.getOp());
                    }
                    if (recordPatchesListValue.getKey() != null) {
                        jsonWriter.key("Key").value(recordPatchesListValue.getKey());
                    }
                    if (recordPatchesListValue.getValue() != null) {
                        jsonWriter.key("Value").value(recordPatchesListValue.getValue());
                    }
                    if (recordPatchesListValue.getSyncCount() != null) {
                        jsonWriter.key("SyncCount").value(recordPatchesListValue.getSyncCount());
                    }
                    if (recordPatchesListValue.getDeviceLastModifiedDate() != null) {
                        jsonWriter.key("DeviceLastModifiedDate").value(recordPatchesListValue.getDeviceLastModifiedDate());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (updateRecordsRequest.getSyncSessionToken() != null) {
                jsonWriter.key("SyncSessionToken").value(updateRecordsRequest.getSyncSessionToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

