/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchdomain.model.UploadDocumentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UploadDocumentsRequestMarshaller
implements Marshaller<Request<UploadDocumentsRequest>, UploadDocumentsRequest> {
    @Override
    public Request<UploadDocumentsRequest> marshall(UploadDocumentsRequest uploadDocumentsRequest) {
        if (uploadDocumentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadDocumentsRequest> request = new DefaultRequest<UploadDocumentsRequest>(uploadDocumentsRequest, "AmazonCloudSearchDomain");
        String target = "AmazonCloudSearch2013.UploadDocuments";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadDocumentsRequest.getContentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong(uploadDocumentsRequest.getContentLength()));
        }
        if (uploadDocumentsRequest.getContentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString(uploadDocumentsRequest.getContentType()));
        }
        String uriResourcePath = "/2013-01-01/documents/batch?format=sdk";
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(uploadDocumentsRequest.getDocuments());
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

