/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.LaunchConfiguration;
import com.amazonaws.services.autoscaling.model.transform.BlockDeviceMappingStaxUnmarshaller;
import com.amazonaws.services.autoscaling.model.transform.InstanceMonitoringStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchConfigurationStaxUnmarshaller
implements Unmarshaller<LaunchConfiguration, StaxUnmarshallerContext> {
    private static LaunchConfigurationStaxUnmarshaller instance;

    @Override
    public LaunchConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchConfiguration launchConfiguration = new LaunchConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return launchConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LaunchConfigurationName", targetDepth)) {
                    launchConfiguration.setLaunchConfigurationName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LaunchConfigurationARN", targetDepth)) {
                    launchConfiguration.setLaunchConfigurationARN(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ImageId", targetDepth)) {
                    launchConfiguration.setImageId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KeyName", targetDepth)) {
                    launchConfiguration.setKeyName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecurityGroups/member", targetDepth)) {
                    launchConfiguration.getSecurityGroups().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UserData", targetDepth)) {
                    launchConfiguration.setUserData(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    launchConfiguration.setInstanceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KernelId", targetDepth)) {
                    launchConfiguration.setKernelId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RamdiskId", targetDepth)) {
                    launchConfiguration.setRamdiskId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BlockDeviceMappings/member", targetDepth)) {
                    launchConfiguration.getBlockDeviceMappings().add(BlockDeviceMappingStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceMonitoring", targetDepth)) {
                    launchConfiguration.setInstanceMonitoring(InstanceMonitoringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SpotPrice", targetDepth)) {
                    launchConfiguration.setSpotPrice(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IamInstanceProfile", targetDepth)) {
                    launchConfiguration.setIamInstanceProfile(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    launchConfiguration.setCreatedTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EbsOptimized", targetDepth)) {
                    launchConfiguration.setEbsOptimized(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AssociatePublicIpAddress", targetDepth)) {
                    launchConfiguration.setAssociatePublicIpAddress(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PlacementTenancy", targetDepth)) continue;
                launchConfiguration.setPlacementTenancy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return launchConfiguration;
    }

    public static LaunchConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LaunchConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

