/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements Serializable {
    private String name;
    private String version;
    private ListWithAutoConstructFlag<String> args;
    private Map<String, String> additionalInfo;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Application withName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Application withVersion(String version) {
        this.version = version;
        return this;
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new ListWithAutoConstructFlag();
            this.args.setAutoConstruct(true);
        }
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
        argsCopy.addAll(args);
        this.args = argsCopy;
    }

    public Application withArgs(String ... args) {
        if (this.getArgs() == null) {
            this.setArgs(new ArrayList<String>(args.length));
        }
        for (String value : args) {
            this.getArgs().add(value);
        }
        return this;
    }

    public Application withArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
        } else {
            ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
            argsCopy.addAll(args);
            this.args = argsCopy;
        }
        return this;
    }

    public Map<String, String> getAdditionalInfo() {
        if (this.additionalInfo == null) {
            this.additionalInfo = new HashMap<String, String>();
        }
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public Application withAdditionalInfo(Map<String, String> additionalInfo) {
        this.setAdditionalInfo(additionalInfo);
        return this;
    }

    public Application addAdditionalInfoEntry(String key, String value) {
        if (null == this.additionalInfo) {
            this.additionalInfo = new HashMap<String, String>();
        }
        if (this.additionalInfo.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalInfo.put(key, value);
        return this;
    }

    public Application clearAdditionalInfoEntries() {
        this.additionalInfo = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: " + this.getVersion() + ",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: " + this.getArgs() + ",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: " + this.getAdditionalInfo());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        if (other.getArgs() != null && !other.getArgs().equals(this.getArgs())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        return other.getAdditionalInfo() == null || other.getAdditionalInfo().equals(this.getAdditionalInfo());
    }
}

