/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateEnvironmentRequestMarshaller
implements Marshaller<Request<UpdateEnvironmentRequest>, UpdateEnvironmentRequest> {
    @Override
    public Request<UpdateEnvironmentRequest> marshall(UpdateEnvironmentRequest updateEnvironmentRequest) {
        EnvironmentTier environmentTierTier;
        if (updateEnvironmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateEnvironmentRequest> request = new DefaultRequest<UpdateEnvironmentRequest>(updateEnvironmentRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "UpdateEnvironment");
        request.addParameter("Version", "2010-12-01");
        if (updateEnvironmentRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString(updateEnvironmentRequest.getEnvironmentId()));
        }
        if (updateEnvironmentRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString(updateEnvironmentRequest.getEnvironmentName()));
        }
        if (updateEnvironmentRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(updateEnvironmentRequest.getDescription()));
        }
        if ((environmentTierTier = updateEnvironmentRequest.getTier()) != null) {
            if (environmentTierTier.getName() != null) {
                request.addParameter("Tier.Name", StringUtils.fromString(environmentTierTier.getName()));
            }
            if (environmentTierTier.getType() != null) {
                request.addParameter("Tier.Type", StringUtils.fromString(environmentTierTier.getType()));
            }
            if (environmentTierTier.getVersion() != null) {
                request.addParameter("Tier.Version", StringUtils.fromString(environmentTierTier.getVersion()));
            }
        }
        if (updateEnvironmentRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString(updateEnvironmentRequest.getVersionLabel()));
        }
        if (updateEnvironmentRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString(updateEnvironmentRequest.getTemplateName()));
        }
        List<ConfigurationOptionSetting> optionSettingsList = updateEnvironmentRequest.getOptionSettings();
        int optionSettingsListIndex = 1;
        for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
            ConfigurationOptionSetting configurationOptionSettingMember = optionSettingsListValue;
            if (configurationOptionSettingMember != null) {
                if (configurationOptionSettingMember.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString(configurationOptionSettingMember.getNamespace()));
                }
                if (configurationOptionSettingMember.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString(configurationOptionSettingMember.getOptionName()));
                }
                if (configurationOptionSettingMember.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString(configurationOptionSettingMember.getValue()));
                }
            }
            ++optionSettingsListIndex;
        }
        List<OptionSpecification> optionsToRemoveList = updateEnvironmentRequest.getOptionsToRemove();
        int optionsToRemoveListIndex = 1;
        for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
            OptionSpecification optionSpecificationMember = optionsToRemoveListValue;
            if (optionSpecificationMember != null) {
                if (optionSpecificationMember.getNamespace() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringUtils.fromString(optionSpecificationMember.getNamespace()));
                }
                if (optionSpecificationMember.getOptionName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringUtils.fromString(optionSpecificationMember.getOptionName()));
                }
            }
            ++optionsToRemoveListIndex;
        }
        return request;
    }
}

