/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch.spi;

import com.amazonaws.metrics.internal.cloudwatch.spi.RequestMetricTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AWSMetricTransformerFactory {
    DynamoDB;

    private static final String REQUEST_TRANSFORMER_CLASSNAME_SUFFIX = "RequestMetricTransformer";
    public static final String DEFAULT_METRIC_TRANSFORM_PROVIDER_PACKAGE = "com.amazonaws.metrics.internal.cloudwatch.provider.transform";
    public static volatile String transformerPackage;
    private volatile RequestMetricTransformer requestMetricTransformer;

    public static String getTransformerPackage() {
        return transformerPackage;
    }

    public static void setTransformerPackage(String transformPackage) {
        if (transformPackage == null) {
            throw new IllegalArgumentException();
        }
        transformerPackage = transformPackage;
    }

    public static String buildRequestMetricTransformerFQCN(String awsPrefix, String packageName) {
        return packageName + "." + awsPrefix + REQUEST_TRANSFORMER_CLASSNAME_SUFFIX;
    }

    private RequestMetricTransformer loadRequestMetricTransformer(String fqcn) {
        Log log = LogFactory.getLog(AWSMetricTransformerFactory.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading " + fqcn));
        }
        try {
            Class<?> c = Class.forName(fqcn);
            return (RequestMetricTransformer)c.newInstance();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to load " + fqcn + "; therefore ignoring " + this.name() + " specific predefined metrics"), e);
            }
            return RequestMetricTransformer.NONE;
        }
    }

    public RequestMetricTransformer getRequestMetricTransformer() {
        RequestMetricTransformer transformer = this.requestMetricTransformer;
        String packageName = transformerPackage;
        if (transformer != null && packageName.equals(transformer.getClass().getPackage().getName())) {
            return transformer;
        }
        String fqcn = AWSMetricTransformerFactory.buildRequestMetricTransformerFQCN(this.name(), packageName);
        this.requestMetricTransformer = this.loadRequestMetricTransformer(fqcn);
        return this.requestMetricTransformer;
    }

    static {
        transformerPackage = DEFAULT_METRIC_TRANSFORM_PROVIDER_PACKAGE;
    }
}

