/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetJobOutputRequestMarshaller
implements Marshaller<Request<GetJobOutputRequest>, GetJobOutputRequest> {
    @Override
    public Request<GetJobOutputRequest> marshall(GetJobOutputRequest getJobOutputRequest) {
        if (getJobOutputRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetJobOutputRequest> request = new DefaultRequest<GetJobOutputRequest>(getJobOutputRequest, "AmazonGlacier");
        String target = "Glacier.GetJobOutput";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        if (getJobOutputRequest.getRange() != null) {
            request.addHeader("Range", StringUtils.fromString(getJobOutputRequest.getRange()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output";
        uriResourcePath = uriResourcePath.replace("{accountId}", getJobOutputRequest.getAccountId() == null ? "" : StringUtils.fromString(getJobOutputRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", getJobOutputRequest.getVaultName() == null ? "" : StringUtils.fromString(getJobOutputRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replace("{jobId}", getJobOutputRequest.getJobId() == null ? "" : StringUtils.fromString(getJobOutputRequest.getJobId()));
        if ((uriResourcePath = uriResourcePath.replaceAll("//", "/")).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

