/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeVpcPeeringConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpcPeeringConnectionsRequest>, DescribeVpcPeeringConnectionsRequest> {
    @Override
    public Request<DescribeVpcPeeringConnectionsRequest> marshall(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        if (describeVpcPeeringConnectionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeVpcPeeringConnectionsRequest> request = new DefaultRequest<DescribeVpcPeeringConnectionsRequest>(describeVpcPeeringConnectionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcPeeringConnections");
        request.addParameter("Version", "2014-05-01");
        List<String> vpcPeeringConnectionIdsList = describeVpcPeeringConnectionsRequest.getVpcPeeringConnectionIds();
        int vpcPeeringConnectionIdsListIndex = 1;
        for (String vpcPeeringConnectionIdsListValue : vpcPeeringConnectionIdsList) {
            if (vpcPeeringConnectionIdsListValue != null) {
                request.addParameter("VpcPeeringConnectionId." + vpcPeeringConnectionIdsListIndex, StringUtils.fromString(vpcPeeringConnectionIdsListValue));
            }
            ++vpcPeeringConnectionIdsListIndex;
        }
        List<Filter> filtersList = describeVpcPeeringConnectionsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

