/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.MultipleFileUpload;
import com.amazonaws.services.s3.transfer.ObjectMetadataProvider;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.internal.DownloadImpl;
import com.amazonaws.services.s3.transfer.internal.DownloadMonitor;
import com.amazonaws.services.s3.transfer.internal.MultipleFileDownloadImpl;
import com.amazonaws.services.s3.transfer.internal.MultipleFileTransfer;
import com.amazonaws.services.s3.transfer.internal.MultipleFileTransferMonitor;
import com.amazonaws.services.s3.transfer.internal.MultipleFileUploadImpl;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.TransferProgressImpl;
import com.amazonaws.services.s3.transfer.internal.TransferProgressUpdatingListener;
import com.amazonaws.services.s3.transfer.internal.TransferStateChangeListener;
import com.amazonaws.services.s3.transfer.internal.UploadCallable;
import com.amazonaws.services.s3.transfer.internal.UploadImpl;
import com.amazonaws.services.s3.transfer.internal.UploadMonitor;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferManager {
    private AmazonS3 s3;
    private TransferManagerConfiguration configuration;
    private ThreadPoolExecutor threadPool;
    private ScheduledExecutorService timedThreadPool = new ScheduledThreadPoolExecutor(1, daemonThreadFactory);
    private static final Log log = LogFactory.getLog(TransferManager.class);
    private static final String USER_AGENT = TransferManager.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String DEFAULT_DELIMITER = "/";
    private static final ThreadFactory daemonThreadFactory = new ThreadFactory(){
        final AtomicInteger threadCount = new AtomicInteger(0);

        public Thread newThread(Runnable r) {
            int threadNumber = this.threadCount.incrementAndGet();
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("S3TransferManagerTimedThread-" + threadNumber);
            return thread;
        }
    };

    public TransferManager(AWSCredentialsProvider credentialsProvider) {
        this(new AmazonS3Client(credentialsProvider));
    }

    public TransferManager(AWSCredentials credentials) {
        this(new AmazonS3Client(credentials));
    }

    public TransferManager(AmazonS3 s3) {
        this(s3, TransferManagerUtils.createDefaultExecutorService());
    }

    public TransferManager(AmazonS3 s3, ThreadPoolExecutor threadPool) {
        this.s3 = s3;
        this.threadPool = threadPool;
        this.configuration = new TransferManagerConfiguration();
    }

    public void setConfiguration(TransferManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public TransferManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonS3 getAmazonS3Client() {
        return this.s3;
    }

    public Upload upload(String bucketName, String key, InputStream input, ObjectMetadata objectMetadata) throws AmazonServiceException, AmazonClientException {
        return this.upload(new PutObjectRequest(bucketName, key, input, objectMetadata));
    }

    public Upload upload(String bucketName, String key, File file) throws AmazonServiceException, AmazonClientException {
        return this.upload(new PutObjectRequest(bucketName, key, file));
    }

    public Upload upload(PutObjectRequest putObjectRequest) throws AmazonServiceException, AmazonClientException {
        return this.upload(putObjectRequest, null);
    }

    private Upload upload(PutObjectRequest putObjectRequest, TransferStateChangeListener stateListener) throws AmazonServiceException, AmazonClientException {
        this.appendUserAgent(putObjectRequest, USER_AGENT);
        if (putObjectRequest.getMetadata() == null) {
            putObjectRequest.setMetadata(new ObjectMetadata());
        }
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        if (TransferManagerUtils.getRequestFile(putObjectRequest) != null) {
            File file = TransferManagerUtils.getRequestFile(putObjectRequest);
            metadata.setContentLength(file.length());
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
        }
        String description = "Uploading to " + putObjectRequest.getBucketName() + DEFAULT_DELIMITER + putObjectRequest.getKey();
        TransferProgressImpl transferProgress = new TransferProgressImpl();
        transferProgress.setTotalBytesToTransfer(TransferManagerUtils.getContentLength(putObjectRequest));
        ProgressListenerChain listenerChain = new ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), putObjectRequest.getGeneralProgressListener());
        putObjectRequest.setGeneralProgressListener(listenerChain);
        UploadImpl upload = new UploadImpl(description, transferProgress, listenerChain, stateListener);
        UploadCallable uploadCallable = new UploadCallable(this, (ExecutorService)this.threadPool, upload, putObjectRequest, listenerChain);
        UploadMonitor watcher = new UploadMonitor(this, upload, (ExecutorService)this.threadPool, uploadCallable, putObjectRequest, listenerChain);
        watcher.setTimedThreadPool(this.timedThreadPool);
        upload.setMonitor(watcher);
        return upload;
    }

    public Download download(String bucket, String key, File file) {
        return this.download(new GetObjectRequest(bucket, key), file);
    }

    public Download download(GetObjectRequest getObjectRequest, File file) {
        return this.download(getObjectRequest, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Download download(final GetObjectRequest getObjectRequest, final File file, TransferStateChangeListener stateListener) {
        this.appendUserAgent(getObjectRequest, USER_AGENT);
        String description = "Downloading from " + getObjectRequest.getBucketName() + DEFAULT_DELIMITER + getObjectRequest.getKey();
        TransferProgressImpl transferProgress = new TransferProgressImpl();
        ProgressListenerChain listenerChain = new ProgressListenerChain(new TransferProgressUpdatingListener(transferProgress), getObjectRequest.getGeneralProgressListener());
        ProgressListenerChain listenerChainForGetObjectRequest = new ProgressListenerChain(new ProgressListenerChain.ProgressEventFilter(){

            public ProgressEvent filter(ProgressEvent progressEvent) {
                if (progressEvent.getEventCode() == 4) {
                    progressEvent.setEventCode(0);
                }
                return progressEvent;
            }
        }, listenerChain);
        getObjectRequest.setGeneralProgressListener(listenerChainForGetObjectRequest);
        ObjectMetadata objectMetadata = this.s3.getObjectMetadata(getObjectRequest.getBucketName(), getObjectRequest.getKey());
        final StartDownloadLock startDownloadLock = new StartDownloadLock();
        final DownloadImpl download = new DownloadImpl(description, (TransferProgress)transferProgress, listenerChain, null, stateListener);
        long contentLength = objectMetadata.getContentLength();
        if (getObjectRequest.getRange() != null && getObjectRequest.getRange().length == 2) {
            long startingByte = getObjectRequest.getRange()[0];
            long lastByte = getObjectRequest.getRange()[1];
            contentLength = lastByte - startingByte;
        }
        transferProgress.setTotalBytesToTransfer(contentLength);
        Future<Object> future = this.threadPool.submit(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                try {
                    StartDownloadLock startDownloadLock2 = startDownloadLock;
                    synchronized (startDownloadLock2) {
                        if (!startDownloadLock.downloadReady) {
                            try {
                                startDownloadLock.wait();
                            }
                            catch (InterruptedException e) {
                                throw new AmazonClientException("Couldn't wait for setting future into the monitor");
                            }
                        }
                    }
                    download.setState(Transfer.TransferState.InProgress);
                    S3Object s3Object = ServiceUtils.retryableDownloadS3ObjectToFile(file, new ServiceUtils.RetryableS3DownloadTask(){

                        public S3Object getS3ObjectStream() {
                            S3Object s3Object = TransferManager.this.s3.getObject(getObjectRequest);
                            download.setS3Object(s3Object);
                            return s3Object;
                        }

                        public boolean needIntegrityCheck() {
                            boolean performIntegrityCheck = true;
                            if (getObjectRequest.getRange() != null) {
                                performIntegrityCheck = false;
                            }
                            if (TransferManager.this.s3 instanceof AmazonS3EncryptionClient) {
                                performIntegrityCheck = false;
                            }
                            return performIntegrityCheck;
                        }
                    });
                    if (s3Object == null) {
                        download.setState(Transfer.TransferState.Canceled);
                        download.setMonitor(new DownloadMonitor(download, null));
                        return download;
                    }
                    download.setState(Transfer.TransferState.Completed);
                    return true;
                }
                catch (Exception e) {
                    if (download.getState() != Transfer.TransferState.Canceled) {
                        download.setState(Transfer.TransferState.Failed);
                    }
                    throw e;
                }
            }
        });
        download.setMonitor(new DownloadMonitor(download, future));
        StartDownloadLock startDownloadLock2 = startDownloadLock;
        synchronized (startDownloadLock2) {
            startDownloadLock.downloadReady = true;
            startDownloadLock.notify();
        }
        return download;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultipleFileDownload downloadDirectory(String bucketName, String keyPrefix, File destinationDirectory) {
        if (keyPrefix == null) {
            keyPrefix = "";
        }
        LinkedList<S3ObjectSummary> objectSummaries = new LinkedList<S3ObjectSummary>();
        Stack<String> commonPrefixes = new Stack<String>();
        commonPrefixes.add(keyPrefix);
        long totalSize = 0L;
        do {
            String prefix = (String)commonPrefixes.pop();
            ObjectListing listObjectsResponse = null;
            do {
                if (listObjectsResponse == null) {
                    ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withDelimiter(DEFAULT_DELIMITER).withPrefix(prefix);
                    listObjectsResponse = this.s3.listObjects(listObjectsRequest);
                } else {
                    listObjectsResponse = this.s3.listNextBatchOfObjects(listObjectsResponse);
                }
                for (S3ObjectSummary s : listObjectsResponse.getObjectSummaries()) {
                    if (!s.getKey().equals(prefix) && !listObjectsResponse.getCommonPrefixes().contains(s.getKey() + DEFAULT_DELIMITER)) {
                        objectSummaries.add(s);
                        totalSize += s.getSize();
                        continue;
                    }
                    log.debug((Object)("Skipping download for object " + s.getKey() + " since it is also a virtual directory"));
                }
                commonPrefixes.addAll(listObjectsResponse.getCommonPrefixes());
            } while (listObjectsResponse.isTruncated());
        } while (!commonPrefixes.isEmpty());
        ProgressListenerChain additionalProgressListenerChain = new ProgressListenerChain(new ProgressListener[0]);
        TransferProgressImpl transferProgress = new TransferProgressImpl();
        transferProgress.setTotalBytesToTransfer(totalSize);
        MultipleFileTransferProgressUpdatingListener multipleFileTransferProgressListener = new MultipleFileTransferProgressUpdatingListener(transferProgress, additionalProgressListenerChain);
        ArrayList<DownloadImpl> downloads = new ArrayList<DownloadImpl>();
        String description = "Downloading from " + bucketName + DEFAULT_DELIMITER + keyPrefix;
        MultipleFileDownloadImpl multipleFileDownload = new MultipleFileDownloadImpl(description, (TransferProgress)transferProgress, additionalProgressListenerChain, keyPrefix, bucketName, downloads);
        multipleFileDownload.setMonitor(new MultipleFileTransferMonitor(multipleFileDownload, downloads));
        AllDownloadsQueuedLock allTransfersQueuedLock = new AllDownloadsQueuedLock();
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(allTransfersQueuedLock, multipleFileDownload);
        for (S3ObjectSummary summary : objectSummaries) {
            File f = new File(destinationDirectory, summary.getKey());
            File parentFile = f.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new RuntimeException("Couldn't create parent directories for " + f.getAbsolutePath());
            }
            downloads.add((DownloadImpl)this.download(new GetObjectRequest(summary.getBucketName(), summary.getKey()).withGeneralProgressListener(multipleFileTransferProgressListener), f, multipleFileTransferStateChangeListener));
        }
        if (downloads.isEmpty()) {
            multipleFileDownload.setState(Transfer.TransferState.Completed);
            return multipleFileDownload;
        }
        AllDownloadsQueuedLock allDownloadsQueuedLock = allTransfersQueuedLock;
        synchronized (allDownloadsQueuedLock) {
            allTransfersQueuedLock.allQueued = true;
            allTransfersQueuedLock.notifyAll();
        }
        return multipleFileDownload;
    }

    public MultipleFileUpload uploadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory, boolean includeSubdirectories) {
        return this.uploadDirectory(bucketName, virtualDirectoryKeyPrefix, directory, includeSubdirectories, null);
    }

    public MultipleFileUpload uploadDirectory(String bucketName, String virtualDirectoryKeyPrefix, File directory, boolean includeSubdirectories, ObjectMetadataProvider metadataProvider) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory to upload");
        }
        LinkedList<File> files = new LinkedList<File>();
        this.listFiles(directory, files, includeSubdirectories);
        return this.uploadFileList(bucketName, virtualDirectoryKeyPrefix, directory, files, metadataProvider);
    }

    public MultipleFileUpload uploadFileList(String bucketName, String virtualDirectoryKeyPrefix, File directory, List<File> files) {
        return this.uploadFileList(bucketName, virtualDirectoryKeyPrefix, directory, files, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultipleFileUpload uploadFileList(String bucketName, String virtualDirectoryKeyPrefix, File directory, List<File> files, ObjectMetadataProvider metadataProvider) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Must provide a common base directory for uploaded files");
        }
        if (virtualDirectoryKeyPrefix == null || virtualDirectoryKeyPrefix.length() == 0) {
            virtualDirectoryKeyPrefix = "";
        } else if (!virtualDirectoryKeyPrefix.endsWith(DEFAULT_DELIMITER)) {
            virtualDirectoryKeyPrefix = virtualDirectoryKeyPrefix + DEFAULT_DELIMITER;
        }
        ProgressListenerChain additionalProgressListenerChain = new ProgressListenerChain(new ProgressListener[0]);
        TransferProgressImpl transferProgress = new TransferProgressImpl();
        MultipleFileTransferProgressUpdatingListener multipleFileTransferProgressListener = new MultipleFileTransferProgressUpdatingListener(transferProgress, additionalProgressListenerChain);
        LinkedList<UploadImpl> uploads = new LinkedList<UploadImpl>();
        MultipleFileUploadImpl multipleFileUpload = new MultipleFileUploadImpl("Uploading etc", (TransferProgress)transferProgress, additionalProgressListenerChain, virtualDirectoryKeyPrefix, bucketName, uploads);
        multipleFileUpload.setMonitor(new MultipleFileTransferMonitor(multipleFileUpload, uploads));
        AllDownloadsQueuedLock allTransfersQueuedLock = new AllDownloadsQueuedLock();
        MultipleFileTransferStateChangeListener multipleFileTransferStateChangeListener = new MultipleFileTransferStateChangeListener(allTransfersQueuedLock, multipleFileUpload);
        if (files == null || files.isEmpty()) {
            multipleFileUpload.setState(Transfer.TransferState.Completed);
        }
        int startingPosition = directory.getAbsolutePath().length();
        if (!directory.getAbsolutePath().endsWith(File.separator)) {
            ++startingPosition;
        }
        long totalSize = 0L;
        for (File f : files) {
            if (!f.isFile()) continue;
            totalSize += f.length();
            String key = f.getAbsolutePath().substring(startingPosition).replaceAll("\\\\", DEFAULT_DELIMITER);
            ObjectMetadata metadata = new ObjectMetadata();
            if (metadataProvider != null) {
                metadataProvider.provideObjectMetadata(f, metadata);
            }
            uploads.add((UploadImpl)this.upload(new PutObjectRequest(bucketName, virtualDirectoryKeyPrefix + key, f).withMetadata(metadata).withGeneralProgressListener(multipleFileTransferProgressListener), multipleFileTransferStateChangeListener));
        }
        transferProgress.setTotalBytesToTransfer(totalSize);
        AllDownloadsQueuedLock allDownloadsQueuedLock = allTransfersQueuedLock;
        synchronized (allDownloadsQueuedLock) {
            allTransfersQueuedLock.allQueued = true;
            allTransfersQueuedLock.notifyAll();
        }
        return multipleFileUpload;
    }

    private void listFiles(File dir, List<File> results, boolean includeSubDirectories) {
        File[] found = dir.listFiles();
        if (found != null) {
            for (File f : found) {
                if (f.isDirectory()) {
                    if (!includeSubDirectories) continue;
                    this.listFiles(f, results, includeSubDirectories);
                    continue;
                }
                results.add(f);
            }
        }
    }

    public void abortMultipartUploads(String bucketName, Date date) throws AmazonServiceException, AmazonClientException {
        ListMultipartUploadsRequest request;
        MultipartUploadListing uploadListing = this.s3.listMultipartUploads(this.appendUserAgent(new ListMultipartUploadsRequest(bucketName), USER_AGENT));
        do {
            for (MultipartUpload upload : uploadListing.getMultipartUploads()) {
                if (upload.getInitiated().compareTo(date) >= 0) continue;
                this.s3.abortMultipartUpload(this.appendUserAgent(new AbortMultipartUploadRequest(bucketName, upload.getKey(), upload.getUploadId()), USER_AGENT));
            }
        } while ((uploadListing = this.s3.listMultipartUploads(this.appendUserAgent(request = new ListMultipartUploadsRequest(bucketName).withUploadIdMarker(uploadListing.getNextUploadIdMarker()).withKeyMarker(uploadListing.getNextKeyMarker()), USER_AGENT))).isTruncated());
    }

    public void shutdownNow() {
        this.threadPool.shutdownNow();
        this.timedThreadPool.shutdownNow();
        if (this.s3 instanceof AmazonS3Client) {
            ((AmazonS3Client)this.s3).shutdown();
        }
    }

    public <X extends AmazonWebServiceRequest> X appendUserAgent(X request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(userAgent);
        return request;
    }

    private static final class MultipleFileTransferProgressUpdatingListener
    extends TransferProgressUpdatingListener {
        private final ProgressListenerCallbackExecutor progressListenerCallbackExecutor;

        public MultipleFileTransferProgressUpdatingListener(TransferProgressImpl transferProgress, ProgressListenerChain progressListenerChain) {
            super(transferProgress);
            this.progressListenerCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListenerChain);
        }

        public void progressChanged(ProgressEvent progressEvent) {
            super.progressChanged(progressEvent);
            this.progressListenerCallbackExecutor.progressChanged(new ProgressEvent(progressEvent.getBytesTransferred()));
        }
    }

    private static final class MultipleFileTransferStateChangeListener
    implements TransferStateChangeListener {
        private final AllDownloadsQueuedLock allTransfersQueuedLock;
        private final MultipleFileTransfer multipleFileTransfer;

        public MultipleFileTransferStateChangeListener(AllDownloadsQueuedLock allTransfersQueuedLock, MultipleFileTransfer multipleFileDownload) {
            this.allTransfersQueuedLock = allTransfersQueuedLock;
            this.multipleFileTransfer = multipleFileDownload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferStateChanged(Transfer upload, Transfer.TransferState state) {
            Object object = this.allTransfersQueuedLock;
            synchronized (object) {
                if (!this.allTransfersQueuedLock.allQueued) {
                    try {
                        this.allTransfersQueuedLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new AmazonClientException("Couldn't wait for all downloads to be queued");
                    }
                }
            }
            object = this.multipleFileTransfer;
            synchronized (object) {
                if (this.multipleFileTransfer.getState() == state || this.multipleFileTransfer.isDone()) {
                    return;
                }
                if (state == Transfer.TransferState.InProgress) {
                    this.multipleFileTransfer.setState(state);
                } else if (this.multipleFileTransfer.getMonitor().isDone()) {
                    this.multipleFileTransfer.collateFinalState();
                } else {
                    this.multipleFileTransfer.setState(Transfer.TransferState.InProgress);
                }
            }
        }
    }

    private static final class StartDownloadLock {
        private volatile boolean downloadReady = false;

        private StartDownloadLock() {
        }
    }

    private static final class AllDownloadsQueuedLock {
        private volatile boolean allQueued = false;

        private AllDownloadsQueuedLock() {
        }
    }
}

