/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command
implements Serializable {
    private String name;
    private String scriptPath;
    private ListWithAutoConstructFlag<String> args;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Command withName(String name) {
        this.name = name;
        return this;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public Command withScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
        return this;
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new ListWithAutoConstructFlag();
            this.args.setAutoConstruct(true);
        }
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
        argsCopy.addAll(args);
        this.args = argsCopy;
    }

    public Command withArgs(String ... args) {
        if (this.getArgs() == null) {
            this.setArgs(new ArrayList<String>(args.length));
        }
        for (String value : args) {
            this.getArgs().add(value);
        }
        return this;
    }

    public Command withArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
        } else {
            ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
            argsCopy.addAll(args);
            this.args = argsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getScriptPath() != null) {
            sb.append("ScriptPath: " + this.getScriptPath() + ",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: " + this.getArgs());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getScriptPath() == null ? 0 : this.getScriptPath().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Command)) {
            return false;
        }
        Command other = (Command)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getScriptPath() == null ^ this.getScriptPath() == null) {
            return false;
        }
        if (other.getScriptPath() != null && !other.getScriptPath().equals(this.getScriptPath())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        return other.getArgs() == null || other.getArgs().equals(this.getArgs());
    }
}

