/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationResult;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsResult;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksResult;
import com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResult;
import com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.transform.CheckDNSAvailabilityRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CheckDNSAvailabilityResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationVersionResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateConfigurationTemplateResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateStorageLocationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateStorageLocationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteEnvironmentConfigurationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationVersionsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationVersionsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationOptionsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationOptionsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationSettingsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationSettingsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentResourcesRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentResourcesResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEventsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEventsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ListAvailableSolutionStacksRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ListAvailableSolutionStacksResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RebuildEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RequestEnvironmentInfoRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RestartAppServerRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RetrieveEnvironmentInfoRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RetrieveEnvironmentInfoResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.S3SubscriptionRequiredExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.SourceBundleDeletionExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.SwapEnvironmentCNAMEsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TerminateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TerminateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyApplicationVersionsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyApplicationsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyBucketsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyConfigurationTemplatesExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyEnvironmentsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationVersionResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateConfigurationTemplateResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ValidateConfigurationSettingsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ValidateConfigurationSettingsResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSElasticBeanstalkClient
extends AmazonWebServiceClient
implements AWSElasticBeanstalk {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AWSElasticBeanstalkClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSElasticBeanstalkClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSElasticBeanstalkClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new TooManyEnvironmentsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new S3SubscriptionRequiredExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyApplicationVersionsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyApplicationsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SourceBundleDeletionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyConfigurationTemplatesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyBucketsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("elasticbeanstalk.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticbeanstalk/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckDNSAvailabilityResult checkDNSAvailability(CheckDNSAvailabilityRequest checkDNSAvailabilityRequest) {
        CheckDNSAvailabilityResult checkDNSAvailabilityResult;
        ExecutionContext executionContext = this.createExecutionContext(checkDNSAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CheckDNSAvailabilityRequest> request = null;
        CheckDNSAvailabilityResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CheckDNSAvailabilityRequestMarshaller().marshall(checkDNSAvailabilityRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            checkDNSAvailabilityResult = response = this.invoke(request, new CheckDNSAvailabilityResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return checkDNSAvailabilityResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationOptionsResult describeConfigurationOptions(DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) {
        DescribeConfigurationOptionsResult describeConfigurationOptionsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeConfigurationOptionsRequest> request = null;
        DescribeConfigurationOptionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeConfigurationOptionsRequestMarshaller().marshall(describeConfigurationOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeConfigurationOptionsResult = response = this.invoke(request, new DescribeConfigurationOptionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeConfigurationOptionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConfigurationTemplate(DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteConfigurationTemplateRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteConfigurationTemplateRequestMarshaller().marshall(deleteConfigurationTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEnvironmentResult createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        CreateEnvironmentResult createEnvironmentResult;
        ExecutionContext executionContext = this.createExecutionContext(createEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateEnvironmentRequest> request = null;
        CreateEnvironmentResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateEnvironmentRequestMarshaller().marshall(createEnvironmentRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createEnvironmentResult = response = this.invoke(request, new CreateEnvironmentResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createEnvironmentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStorageLocationResult createStorageLocation(CreateStorageLocationRequest createStorageLocationRequest) {
        CreateStorageLocationResult createStorageLocationResult;
        ExecutionContext executionContext = this.createExecutionContext(createStorageLocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateStorageLocationRequest> request = null;
        CreateStorageLocationResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateStorageLocationRequestMarshaller().marshall(createStorageLocationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createStorageLocationResult = response = this.invoke(request, new CreateStorageLocationResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createStorageLocationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestEnvironmentInfo(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(requestEnvironmentInfoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RequestEnvironmentInfoRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RequestEnvironmentInfoRequestMarshaller().marshall(requestEnvironmentInfoRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationVersionResult createApplicationVersion(CreateApplicationVersionRequest createApplicationVersionRequest) {
        CreateApplicationVersionResult createApplicationVersionResult;
        ExecutionContext executionContext = this.createExecutionContext(createApplicationVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateApplicationVersionRequest> request = null;
        CreateApplicationVersionResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateApplicationVersionRequestMarshaller().marshall(createApplicationVersionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createApplicationVersionResult = response = this.invoke(request, new CreateApplicationVersionResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createApplicationVersionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplicationVersion(DeleteApplicationVersionRequest deleteApplicationVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteApplicationVersionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteApplicationVersionRequestMarshaller().marshall(deleteApplicationVersionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationVersionsResult describeApplicationVersions(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        DescribeApplicationVersionsResult describeApplicationVersionsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeApplicationVersionsRequest> request = null;
        DescribeApplicationVersionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeApplicationVersionsRequestMarshaller().marshall(describeApplicationVersionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeApplicationVersionsResult = response = this.invoke(request, new DescribeApplicationVersionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeApplicationVersionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteApplicationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteApplicationRequestMarshaller().marshall(deleteApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationVersionResult updateApplicationVersion(UpdateApplicationVersionRequest updateApplicationVersionRequest) {
        UpdateApplicationVersionResult updateApplicationVersionResult;
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateApplicationVersionRequest> request = null;
        UpdateApplicationVersionResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateApplicationVersionRequestMarshaller().marshall(updateApplicationVersionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateApplicationVersionResult = response = this.invoke(request, new UpdateApplicationVersionResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateApplicationVersionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest createApplicationRequest) {
        CreateApplicationResult createApplicationResult;
        ExecutionContext executionContext = this.createExecutionContext(createApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateApplicationRequest> request = null;
        CreateApplicationResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateApplicationRequestMarshaller().marshall(createApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createApplicationResult = response = this.invoke(request, new CreateApplicationResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createApplicationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapEnvironmentCNAMEs(SwapEnvironmentCNAMEsRequest swapEnvironmentCNAMEsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(swapEnvironmentCNAMEsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SwapEnvironmentCNAMEsRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SwapEnvironmentCNAMEsRequestMarshaller().marshall(swapEnvironmentCNAMEsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationTemplateResult updateConfigurationTemplate(UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) {
        UpdateConfigurationTemplateResult updateConfigurationTemplateResult;
        ExecutionContext executionContext = this.createExecutionContext(updateConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateConfigurationTemplateRequest> request = null;
        UpdateConfigurationTemplateResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateConfigurationTemplateRequestMarshaller().marshall(updateConfigurationTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateConfigurationTemplateResult = response = this.invoke(request, new UpdateConfigurationTemplateResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateConfigurationTemplateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetrieveEnvironmentInfoResult retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) {
        RetrieveEnvironmentInfoResult retrieveEnvironmentInfoResult;
        ExecutionContext executionContext = this.createExecutionContext(retrieveEnvironmentInfoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RetrieveEnvironmentInfoRequest> request = null;
        RetrieveEnvironmentInfoResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RetrieveEnvironmentInfoRequestMarshaller().marshall(retrieveEnvironmentInfoRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            retrieveEnvironmentInfoResult = response = this.invoke(request, new RetrieveEnvironmentInfoResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return retrieveEnvironmentInfoResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAvailableSolutionStacksResult listAvailableSolutionStacks(ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) {
        ListAvailableSolutionStacksResult listAvailableSolutionStacksResult;
        ExecutionContext executionContext = this.createExecutionContext(listAvailableSolutionStacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListAvailableSolutionStacksRequest> request = null;
        ListAvailableSolutionStacksResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListAvailableSolutionStacksRequestMarshaller().marshall(listAvailableSolutionStacksRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            listAvailableSolutionStacksResult = response = this.invoke(request, new ListAvailableSolutionStacksResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listAvailableSolutionStacksResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        UpdateApplicationResult updateApplicationResult;
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateApplicationRequest> request = null;
        UpdateApplicationResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateApplicationRequestMarshaller().marshall(updateApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateApplicationResult = response = this.invoke(request, new UpdateApplicationResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateApplicationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEnvironmentsResult describeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        DescribeEnvironmentsResult describeEnvironmentsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeEnvironmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeEnvironmentsRequest> request = null;
        DescribeEnvironmentsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeEnvironmentsRequestMarshaller().marshall(describeEnvironmentsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeEnvironmentsResult = response = this.invoke(request, new DescribeEnvironmentsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeEnvironmentsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEnvironmentResourcesResult describeEnvironmentResources(DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) {
        DescribeEnvironmentResourcesResult describeEnvironmentResourcesResult;
        ExecutionContext executionContext = this.createExecutionContext(describeEnvironmentResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeEnvironmentResourcesRequest> request = null;
        DescribeEnvironmentResourcesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeEnvironmentResourcesRequestMarshaller().marshall(describeEnvironmentResourcesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeEnvironmentResourcesResult = response = this.invoke(request, new DescribeEnvironmentResourcesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeEnvironmentResourcesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateEnvironmentResult terminateEnvironment(TerminateEnvironmentRequest terminateEnvironmentRequest) {
        TerminateEnvironmentResult terminateEnvironmentResult;
        ExecutionContext executionContext = this.createExecutionContext(terminateEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<TerminateEnvironmentRequest> request = null;
        TerminateEnvironmentResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new TerminateEnvironmentRequestMarshaller().marshall(terminateEnvironmentRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            terminateEnvironmentResult = response = this.invoke(request, new TerminateEnvironmentResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return terminateEnvironmentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateConfigurationSettingsResult validateConfigurationSettings(ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) {
        ValidateConfigurationSettingsResult validateConfigurationSettingsResult;
        ExecutionContext executionContext = this.createExecutionContext(validateConfigurationSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ValidateConfigurationSettingsRequest> request = null;
        ValidateConfigurationSettingsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ValidateConfigurationSettingsRequestMarshaller().marshall(validateConfigurationSettingsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            validateConfigurationSettingsResult = response = this.invoke(request, new ValidateConfigurationSettingsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return validateConfigurationSettingsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartAppServer(RestartAppServerRequest restartAppServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restartAppServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RestartAppServerRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RestartAppServerRequestMarshaller().marshall(restartAppServerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEnvironmentConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteEnvironmentConfigurationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteEnvironmentConfigurationRequestMarshaller().marshall(deleteEnvironmentConfigurationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEnvironmentResult updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        UpdateEnvironmentResult updateEnvironmentResult;
        ExecutionContext executionContext = this.createExecutionContext(updateEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateEnvironmentRequest> request = null;
        UpdateEnvironmentResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateEnvironmentRequestMarshaller().marshall(updateEnvironmentRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateEnvironmentResult = response = this.invoke(request, new UpdateEnvironmentResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateEnvironmentResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationTemplateResult createConfigurationTemplate(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        CreateConfigurationTemplateResult createConfigurationTemplateResult;
        ExecutionContext executionContext = this.createExecutionContext(createConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateConfigurationTemplateRequest> request = null;
        CreateConfigurationTemplateResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateConfigurationTemplateRequestMarshaller().marshall(createConfigurationTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createConfigurationTemplateResult = response = this.invoke(request, new CreateConfigurationTemplateResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createConfigurationTemplateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationSettingsResult describeConfigurationSettings(DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) {
        DescribeConfigurationSettingsResult describeConfigurationSettingsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeConfigurationSettingsRequest> request = null;
        DescribeConfigurationSettingsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeConfigurationSettingsRequestMarshaller().marshall(describeConfigurationSettingsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeConfigurationSettingsResult = response = this.invoke(request, new DescribeConfigurationSettingsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeConfigurationSettingsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationsResult describeApplications(DescribeApplicationsRequest describeApplicationsRequest) {
        DescribeApplicationsResult describeApplicationsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeApplicationsRequest> request = null;
        DescribeApplicationsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeApplicationsRequestMarshaller().marshall(describeApplicationsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeApplicationsResult = response = this.invoke(request, new DescribeApplicationsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeApplicationsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildEnvironment(RebuildEnvironmentRequest rebuildEnvironmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rebuildEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RebuildEnvironmentRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RebuildEnvironmentRequestMarshaller().marshall(rebuildEnvironmentRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest describeEventsRequest) {
        DescribeEventsResult describeEventsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeEventsRequest> request = null;
        DescribeEventsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeEventsRequestMarshaller().marshall(describeEventsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeEventsResult = response = this.invoke(request, new DescribeEventsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeEventsResult;
    }

    @Override
    public CreateStorageLocationResult createStorageLocation() throws AmazonServiceException, AmazonClientException {
        return this.createStorageLocation(new CreateStorageLocationRequest());
    }

    @Override
    public DescribeApplicationVersionsResult describeApplicationVersions() throws AmazonServiceException, AmazonClientException {
        return this.describeApplicationVersions(new DescribeApplicationVersionsRequest());
    }

    @Override
    public void swapEnvironmentCNAMEs() throws AmazonServiceException, AmazonClientException {
        this.swapEnvironmentCNAMEs(new SwapEnvironmentCNAMEsRequest());
    }

    @Override
    public ListAvailableSolutionStacksResult listAvailableSolutionStacks() throws AmazonServiceException, AmazonClientException {
        return this.listAvailableSolutionStacks(new ListAvailableSolutionStacksRequest());
    }

    @Override
    public DescribeEnvironmentsResult describeEnvironments() throws AmazonServiceException, AmazonClientException {
        return this.describeEnvironments(new DescribeEnvironmentsRequest());
    }

    @Override
    public DescribeApplicationsResult describeApplications() throws AmazonServiceException, AmazonClientException {
        return this.describeApplications(new DescribeApplicationsRequest());
    }

    @Override
    public DescribeEventsResult describeEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeEvents(new DescribeEventsRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "elasticbeanstalk";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

