/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CopySnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopySnapshotRequestMarshaller
implements Marshaller<Request<CopySnapshotRequest>, CopySnapshotRequest> {
    @Override
    public Request<CopySnapshotRequest> marshall(CopySnapshotRequest copySnapshotRequest) {
        if (copySnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopySnapshotRequest> request = new DefaultRequest<CopySnapshotRequest>(copySnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "CopySnapshot");
        request.addParameter("Version", "2013-10-01");
        if (copySnapshotRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString(copySnapshotRequest.getSourceRegion()));
        }
        if (copySnapshotRequest.getSourceSnapshotId() != null) {
            request.addParameter("SourceSnapshotId", StringUtils.fromString(copySnapshotRequest.getSourceSnapshotId()));
        }
        if (copySnapshotRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(copySnapshotRequest.getDescription()));
        }
        return request;
    }
}

