/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.config;

import com.amazonaws.auth.AWS3Signer;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.auth.Signer;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SignerType {
    AWS3SignerType{

        public Signer createSigner() {
            return AWS3Signer.Instance;
        }
    }
    ,
    AWS4SignerType{

        public Signer createV4Signer(boolean doubleUrlEncode) {
            Class[] paramTypes = new Class[]{Boolean.TYPE};
            return SignerType.createSignerWith(this.fqcn, paramTypes, new Object[]{doubleUrlEncode});
        }
    }
    ,
    CloudFrontSignerType,
    QueryStringSignerType{

        public Signer createSigner() {
            return QueryStringSigner.Instance;
        }
    }
    ,
    S3SignerType("com.amazonaws.services.s3.internal"){

        public Signer createSigner() {
            throw new UnsupportedOperationException();
        }

        public Signer createS3Signer(String httpVerb, String resourcePath) {
            Class[] paramTypes = new Class[]{String.class, String.class};
            return SignerType.createSignerWith(this.fqcn, paramTypes, new Object[]{httpVerb, resourcePath});
        }
    }
    ,
    AWSS3V4SignerType;

    final String fqcn;

    private SignerType() {
        this.fqcn = _.SIGNER_DEFAULT_PACKAGE.getName() + "." + this.nameWithoutType();
    }

    private String nameWithoutType() {
        String name = this.name();
        return name.substring(0, name.length() - 4);
    }

    private SignerType(String packageName) {
        this.fqcn = packageName + "." + this.nameWithoutType();
    }

    Signer createSigner() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = loader.loadClass(this.fqcn);
            return (Signer)c.newInstance();
        }
        catch (Exception e) {
            throw SignerType.toRuntimeException(e);
        }
    }

    Signer createV4Signer(boolean doubleUrlEncode) {
        throw new UnsupportedOperationException();
    }

    Signer createS3Signer(String httpVerb, String resourcePath) {
        throw new UnsupportedOperationException();
    }

    private static Signer createSignerWith(String fqcn, Class<?>[] ctorParamTypes, Object ... ctorParams) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = loader.loadClass(fqcn);
            Constructor<?> ctor = c.getConstructor(ctorParamTypes);
            return (Signer)ctor.newInstance(ctorParams);
        }
        catch (Exception e) {
            throw SignerType.toRuntimeException(e);
        }
    }

    private static RuntimeException toRuntimeException(Exception e) {
        return e instanceof RuntimeException ? (RuntimeException)e : new IllegalStateException(e);
    }

    private static class _ {
        private static final Package SIGNER_DEFAULT_PACKAGE = Signer.class.getPackage();
        private static final String S3_SIGNER_PACKAGE = "com.amazonaws.services.s3.internal";

        private _() {
        }
    }
}

