/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.config;

import com.amazonaws.internal.config.InternalConfigJsonHelper;
import com.amazonaws.internal.config.SignerConfig;
import com.amazonaws.internal.config.SignerConfigJsonHelper;
import com.amazonaws.internal.config.SignerJsonIndex;
import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class InternalConfig {
    private static final Log log = LogFactory.getLog(InternalConfig.class);
    static final String DEFAULT_CONFIG_RESOURCE = "awssdk_config.json";
    static final String CONFIG_OVERRIDE_RESOURCE = "awssdk_config_override.json";
    private static final String SERVICE_REGION_DELIMITOR = "/";
    private final SignerConfig defaultSignerConfig;
    private final Map<String, SignerConfig> serviceRegionSigners;
    private final Map<String, SignerConfig> regionSigners;
    private final Map<String, SignerConfig> serviceSigners;

    InternalConfig(InternalConfigJsonHelper defaults, InternalConfigJsonHelper override) {
        SignerConfigJsonHelper scb = defaults.getDefaultSigner();
        this.defaultSignerConfig = scb == null ? null : scb.build();
        this.regionSigners = this.mergeSignerMap(defaults.getRegionSigners(), override.getRegionSigners(), "region");
        this.serviceSigners = this.mergeSignerMap(defaults.getServiceSigners(), override.getServiceSigners(), "service");
        this.serviceRegionSigners = this.mergeSignerMap(defaults.getServiceRegionSigners(), override.getServiceRegionSigners(), "service/region");
    }

    private Map<String, SignerConfig> mergeSignerMap(SignerJsonIndex[] defaults, SignerJsonIndex[] overrides, String theme) {
        Map<String, SignerConfig> map = this.buildSignerMap(defaults, theme);
        Map<String, SignerConfig> mapOverride = this.buildSignerMap(overrides, theme);
        map.putAll(mapOverride);
        return Collections.unmodifiableMap(map);
    }

    private Map<String, SignerConfig> buildSignerMap(SignerJsonIndex[] signerIndexes, String theme) {
        HashMap<String, SignerConfig> map = new HashMap<String, SignerConfig>();
        if (signerIndexes != null) {
            for (SignerJsonIndex index : signerIndexes) {
                String region = index.getKey();
                SignerConfig prev = map.put(region, index.newSignerConfig());
                if (prev == null) continue;
                log.warn((Object)("Duplicate definition of signer for " + theme + " " + index.getKey()));
            }
        }
        return map;
    }

    public SignerConfig getSignerConfig(String serviceName) {
        return this.getSignerConfig(serviceName, null);
    }

    public SignerConfig getSignerConfig(String serviceName, String regionName) {
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        SignerConfig signerConfig = null;
        if (regionName != null) {
            String key = serviceName + SERVICE_REGION_DELIMITOR + regionName;
            signerConfig = this.serviceRegionSigners.get(key);
            if (signerConfig != null) {
                return signerConfig;
            }
            signerConfig = this.regionSigners.get(regionName);
            if (signerConfig != null) {
                return signerConfig;
            }
        }
        return (signerConfig = this.serviceSigners.get(serviceName)) == null ? this.defaultSignerConfig : signerConfig;
    }

    static InternalConfigJsonHelper loadfrom(URL url) throws JsonParseException, JsonMappingException, IOException {
        InternalConfigJsonHelper target = (InternalConfigJsonHelper)Jackson.getObjectMapper().readValue(url, InternalConfigJsonHelper.class);
        return target;
    }

    static InternalConfig load() throws JsonParseException, JsonMappingException, IOException {
        InternalConfigJsonHelper configOverride;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(DEFAULT_CONFIG_RESOURCE);
        InternalConfigJsonHelper config = InternalConfig.loadfrom(url);
        URL overrideUrl = loader.getResource(CONFIG_OVERRIDE_RESOURCE);
        if (overrideUrl == null) {
            log.debug((Object)"Configuration override awssdk_config_override.json not found.");
            configOverride = new InternalConfigJsonHelper();
        } else {
            configOverride = InternalConfig.loadfrom(overrideUrl);
        }
        return new InternalConfig(config, configOverride);
    }

    void dump() {
        StringBuilder sb = new StringBuilder().append("defaultSignerConfig: ").append(this.defaultSignerConfig).append("\n").append("serviceRegionSigners: ").append(this.serviceRegionSigners).append("\n").append("regionSigners: ").append(this.regionSigners).append("\n").append("serviceSigners: ").append(this.serviceSigners);
        log.debug((Object)sb.toString());
    }

    public static class Factory {
        private static final InternalConfig SINGELTON;

        public static InternalConfig getInternalConfig() {
            return SINGELTON;
        }

        static {
            InternalConfig config = null;
            try {
                config = InternalConfig.load();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Fatal: Failed to load the internal config for AWS Java SDK", ex);
            }
            SINGELTON = config;
        }
    }
}

