/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.Signer;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.internal.config.SignerConfig;
import com.amazonaws.internal.config.SignerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SignerFactory {


    public static Signer getSigner(String serviceName, String regionName) {
        InternalConfig config = InternalConfig.Factory.getInternalConfig();
        SignerConfig signerConfig = config.getSignerConfig(serviceName, regionName);
        Signer signer = signerConfig.computeSigner();
        SignerType type = signerConfig.getSignerType();
        switch (type) {
            case AWS4SignerType: {
                AWS4Signer v4 = (AWS4Signer)signer;
                v4.setServiceName(serviceName);
                v4.setRegionName(regionName);
            }
        }
        return signer;
    }

    public static Signer getSigner(String serviceName) {
        return SignerFactory.getSigner(serviceName, null);
    }
}

