/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.support.AWSSupport;
import com.amazonaws.services.support.model.AddCommunicationToCaseRequest;
import com.amazonaws.services.support.model.AddCommunicationToCaseResult;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.services.support.model.CreateCaseResult;
import com.amazonaws.services.support.model.DescribeCasesRequest;
import com.amazonaws.services.support.model.DescribeCasesResult;
import com.amazonaws.services.support.model.DescribeCommunicationsRequest;
import com.amazonaws.services.support.model.DescribeCommunicationsResult;
import com.amazonaws.services.support.model.DescribeServicesRequest;
import com.amazonaws.services.support.model.DescribeServicesResult;
import com.amazonaws.services.support.model.DescribeSeverityLevelsRequest;
import com.amazonaws.services.support.model.DescribeSeverityLevelsResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksResult;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckRequest;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckResult;
import com.amazonaws.services.support.model.ResolveCaseRequest;
import com.amazonaws.services.support.model.ResolveCaseResult;
import com.amazonaws.services.support.model.transform.AddCommunicationToCaseRequestMarshaller;
import com.amazonaws.services.support.model.transform.AddCommunicationToCaseResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.CaseCreationLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.support.model.transform.CaseIdNotFoundExceptionUnmarshaller;
import com.amazonaws.services.support.model.transform.CreateCaseRequestMarshaller;
import com.amazonaws.services.support.model.transform.CreateCaseResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeCasesRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeCasesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeCommunicationsRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeCommunicationsResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeServicesRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeServicesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeSeverityLevelsRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeSeverityLevelsResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckRefreshStatusesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckResultRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckResultResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckSummariesRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckSummariesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorChecksRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorChecksResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.support.model.transform.RefreshTrustedAdvisorCheckRequestMarshaller;
import com.amazonaws.services.support.model.transform.RefreshTrustedAdvisorCheckResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.ResolveCaseRequestMarshaller;
import com.amazonaws.services.support.model.transform.ResolveCaseResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSSupportClient
extends AmazonWebServiceClient
implements AWSSupport {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSupport.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AWSSupportClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSSupportClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSSupportClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSSupportClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSSupportClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSSupportClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new CaseCreationLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CaseIdNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("support.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("support");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/support/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCasesResult describeCases(DescribeCasesRequest describeCasesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeCasesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeCasesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeCasesRequestMarshaller().marshall(describeCasesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeCasesResultJsonUnmarshaller unmarshaller = new DescribeCasesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeCasesResult> responseHandler = new JsonResponseHandler<DescribeCasesResult>(unmarshaller);
        return (DescribeCasesResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedAdvisorCheckRefreshStatusesResult describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeTrustedAdvisorCheckRefreshStatusesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeTrustedAdvisorCheckRefreshStatusesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller().marshall(describeTrustedAdvisorCheckRefreshStatusesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeTrustedAdvisorCheckRefreshStatusesResultJsonUnmarshaller unmarshaller = new DescribeTrustedAdvisorCheckRefreshStatusesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeTrustedAdvisorCheckRefreshStatusesResult> responseHandler = new JsonResponseHandler<DescribeTrustedAdvisorCheckRefreshStatusesResult>(unmarshaller);
        return (DescribeTrustedAdvisorCheckRefreshStatusesResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSeverityLevelsResult describeSeverityLevels(DescribeSeverityLevelsRequest describeSeverityLevelsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeSeverityLevelsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeSeverityLevelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeSeverityLevelsRequestMarshaller().marshall(describeSeverityLevelsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeSeverityLevelsResultJsonUnmarshaller unmarshaller = new DescribeSeverityLevelsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeSeverityLevelsResult> responseHandler = new JsonResponseHandler<DescribeSeverityLevelsResult>(unmarshaller);
        return (DescribeSeverityLevelsResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCommunicationsResult describeCommunications(DescribeCommunicationsRequest describeCommunicationsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeCommunicationsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeCommunicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeCommunicationsRequestMarshaller().marshall(describeCommunicationsRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeCommunicationsResultJsonUnmarshaller unmarshaller = new DescribeCommunicationsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeCommunicationsResult> responseHandler = new JsonResponseHandler<DescribeCommunicationsResult>(unmarshaller);
        return (DescribeCommunicationsResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddCommunicationToCaseResult addCommunicationToCase(AddCommunicationToCaseRequest addCommunicationToCaseRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddCommunicationToCaseRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(addCommunicationToCaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new AddCommunicationToCaseRequestMarshaller().marshall(addCommunicationToCaseRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        AddCommunicationToCaseResultJsonUnmarshaller unmarshaller = new AddCommunicationToCaseResultJsonUnmarshaller();
        JsonResponseHandler<AddCommunicationToCaseResult> responseHandler = new JsonResponseHandler<AddCommunicationToCaseResult>(unmarshaller);
        return (AddCommunicationToCaseResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCaseResult createCase(CreateCaseRequest createCaseRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateCaseRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(createCaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new CreateCaseRequestMarshaller().marshall(createCaseRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        CreateCaseResultJsonUnmarshaller unmarshaller = new CreateCaseResultJsonUnmarshaller();
        JsonResponseHandler<CreateCaseResult> responseHandler = new JsonResponseHandler<CreateCaseResult>(unmarshaller);
        return (CreateCaseResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedAdvisorChecksResult describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeTrustedAdvisorChecksRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeTrustedAdvisorChecksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeTrustedAdvisorChecksRequestMarshaller().marshall(describeTrustedAdvisorChecksRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeTrustedAdvisorChecksResultJsonUnmarshaller unmarshaller = new DescribeTrustedAdvisorChecksResultJsonUnmarshaller();
        JsonResponseHandler<DescribeTrustedAdvisorChecksResult> responseHandler = new JsonResponseHandler<DescribeTrustedAdvisorChecksResult>(unmarshaller);
        return (DescribeTrustedAdvisorChecksResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedAdvisorCheckResultResult describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeTrustedAdvisorCheckResultRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeTrustedAdvisorCheckResultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeTrustedAdvisorCheckResultRequestMarshaller().marshall(describeTrustedAdvisorCheckResultRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeTrustedAdvisorCheckResultResultJsonUnmarshaller unmarshaller = new DescribeTrustedAdvisorCheckResultResultJsonUnmarshaller();
        JsonResponseHandler<DescribeTrustedAdvisorCheckResultResult> responseHandler = new JsonResponseHandler<DescribeTrustedAdvisorCheckResultResult>(unmarshaller);
        return (DescribeTrustedAdvisorCheckResultResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolveCaseResult resolveCase(ResolveCaseRequest resolveCaseRequest) throws AmazonServiceException, AmazonClientException {
        Request<ResolveCaseRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(resolveCaseRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ResolveCaseRequestMarshaller().marshall(resolveCaseRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        ResolveCaseResultJsonUnmarshaller unmarshaller = new ResolveCaseResultJsonUnmarshaller();
        JsonResponseHandler<ResolveCaseResult> responseHandler = new JsonResponseHandler<ResolveCaseResult>(unmarshaller);
        return (ResolveCaseResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefreshTrustedAdvisorCheckResult refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) throws AmazonServiceException, AmazonClientException {
        Request<RefreshTrustedAdvisorCheckRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(refreshTrustedAdvisorCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new RefreshTrustedAdvisorCheckRequestMarshaller().marshall(refreshTrustedAdvisorCheckRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        RefreshTrustedAdvisorCheckResultJsonUnmarshaller unmarshaller = new RefreshTrustedAdvisorCheckResultJsonUnmarshaller();
        JsonResponseHandler<RefreshTrustedAdvisorCheckResult> responseHandler = new JsonResponseHandler<RefreshTrustedAdvisorCheckResult>(unmarshaller);
        return (RefreshTrustedAdvisorCheckResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServicesResult describeServices(DescribeServicesRequest describeServicesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeServicesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeServicesRequestMarshaller().marshall(describeServicesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeServicesResultJsonUnmarshaller unmarshaller = new DescribeServicesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeServicesResult> responseHandler = new JsonResponseHandler<DescribeServicesResult>(unmarshaller);
        return (DescribeServicesResult)this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedAdvisorCheckSummariesResult describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeTrustedAdvisorCheckSummariesRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(describeTrustedAdvisorCheckSummariesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DescribeTrustedAdvisorCheckSummariesRequestMarshaller().marshall(describeTrustedAdvisorCheckSummariesRequest);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        DescribeTrustedAdvisorCheckSummariesResultJsonUnmarshaller unmarshaller = new DescribeTrustedAdvisorCheckSummariesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeTrustedAdvisorCheckSummariesResult> responseHandler = new JsonResponseHandler<DescribeTrustedAdvisorCheckSummariesResult>(unmarshaller);
        return (DescribeTrustedAdvisorCheckSummariesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeCasesResult describeCases() throws AmazonServiceException, AmazonClientException {
        return this.describeCases(new DescribeCasesRequest());
    }

    @Override
    public DescribeSeverityLevelsResult describeSeverityLevels() throws AmazonServiceException, AmazonClientException {
        return this.describeSeverityLevels(new DescribeSeverityLevelsRequest());
    }

    @Override
    public ResolveCaseResult resolveCase() throws AmazonServiceException, AmazonClientException {
        return this.resolveCase(new ResolveCaseRequest());
    }

    @Override
    public DescribeServicesResult describeServices() throws AmazonServiceException, AmazonClientException {
        return this.describeServices(new DescribeServicesRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "${region.lookup.name}";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return (X)result;
    }
}

