/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.annotation.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class TimingInfo {
    static final int UNKNOWN = -1;
    private final Long startEpochTimeMilli;
    private final long startTimeNano;
    private Long endTimeNano;

    public static TimingInfo startTiming() {
        return new TimingInfo(System.currentTimeMillis(), System.nanoTime(), null);
    }

    protected TimingInfo(Long startEpochTimeMilli, long startTimeNano, Long endTimeNano) {
        this.startEpochTimeMilli = startEpochTimeMilli;
        this.startTimeNano = startTimeNano;
        this.endTimeNano = endTimeNano;
    }

    @Deprecated
    public final long getStartTime() {
        return this.isStartEpochTimeMilliKnown() ? this.startEpochTimeMilli.longValue() : TimeUnit.NANOSECONDS.toMillis(this.startTimeNano);
    }

    @Deprecated
    public final long getStartEpochTimeMilli() {
        Long v = this.getStartEpochTimeMilliIfKnown();
        return v == null ? -1L : v;
    }

    public final Long getStartEpochTimeMilliIfKnown() {
        return this.startEpochTimeMilli;
    }

    public final long getStartTimeNano() {
        return this.startTimeNano;
    }

    @Deprecated
    public final long getEndTime() {
        return this.getEndEpochTimeMilli();
    }

    @Deprecated
    public final long getEndEpochTimeMilli() {
        Long v = this.getEndEpochTimeMilliIfKnown();
        return v == null ? -1L : v;
    }

    public final Long getEndEpochTimeMilliIfKnown() {
        return this.isStartEpochTimeMilliKnown() && this.isEndTimeKnown() ? Long.valueOf(this.startEpochTimeMilli + TimeUnit.NANOSECONDS.toMillis(this.endTimeNano - this.startTimeNano)) : null;
    }

    public final long getEndTimeNano() {
        return this.endTimeNano == null ? -1L : this.endTimeNano;
    }

    public final Long getEndTimeNanoIfKnown() {
        return this.endTimeNano;
    }

    @Deprecated
    public final double getTimeTakenMillis() {
        Double v = this.getTimeTakenMillisIfKnown();
        return v == null ? -1.0 : v;
    }

    public final Double getTimeTakenMillisIfKnown() {
        if (this.isEndTimeKnown()) {
            double micros = TimeUnit.NANOSECONDS.toMicros(this.endTimeNano - this.startTimeNano);
            return micros / 1000.0;
        }
        return null;
    }

    @Deprecated
    public final long getElapsedTimeMillis() {
        Double v = this.getTimeTakenMillisIfKnown();
        return v == null ? -1L : v.longValue();
    }

    public final boolean isEndTimeKnown() {
        return this.endTimeNano != null;
    }

    public final boolean isStartEpochTimeMilliKnown() {
        return this.startEpochTimeMilli != null;
    }

    public final String toString() {
        return String.valueOf(this.getTimeTakenMillis());
    }

    @Deprecated
    public final void setEndTime(long endTimeMilli) {
        this.endTimeNano = TimeUnit.MILLISECONDS.toNanos(endTimeMilli);
    }

    public final void setEndTimeNano(long endTimeNano) {
        this.endTimeNano = endTimeNano;
    }

    public final TimingInfo endTiming() {
        this.endTimeNano = System.nanoTime();
        return this;
    }

    public void addSubMeasurement(String subMeasurementName, TimingInfo timingInfo) {
    }

    public TimingInfo getSubMeasurement(String subMeasurementName) {
        return null;
    }

    public TimingInfo getSubMeasurement(String subMesurementName, int index) {
        return null;
    }

    public TimingInfo getLastSubMeasurement(String subMeasurementName) {
        return null;
    }

    public List<TimingInfo> getAllSubMeasurements(String subMeasurementName) {
        return null;
    }

    public Map<String, List<TimingInfo>> getSubMeasurementsByName() {
        return null;
    }

    public Number getCounter(String key) {
        return null;
    }

    public Map<String, Number> getAllCounters() {
        return Collections.emptyMap();
    }

    public void setCounter(String key, long count) {
    }

    public void incrementCounter(String key) {
    }
}

