/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import com.amazonaws.util.TimingInfoFullSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class AWSRequestMetricsFullSupport
extends AWSRequestMetrics {
    private final Map<String, List<Object>> properties = new HashMap<String, List<Object>>();
    private final Map<String, TimingInfo> eventsBeingProfiled = new HashMap<String, TimingInfo>();
    private static final Log latencyLogger = LogFactory.getLog((String)"com.amazonaws.latency");
    private static final Object KEY_VALUE_SEPARATOR = "=";
    private static final Object COMMA_SEPARATOR = ", ";

    public AWSRequestMetricsFullSupport() {
        super(TimingInfoFullSupport.startTiming());
    }

    @Override
    public void startEvent(String eventName) {
        this.eventsBeingProfiled.put(eventName, TimingInfoFullSupport.startTiming(System.nanoTime()));
    }

    @Override
    public void startEvent(AWSRequestMetrics.Field f) {
        this.startEvent(f.name());
    }

    @Override
    public void endEvent(String eventName) {
        TimingInfo timingInfo = this.eventsBeingProfiled.get(eventName);
        if (timingInfo == null) {
            LogFactory.getLog(this.getClass()).warn((Object)("Trying to end an event which was never started: " + eventName));
            return;
        }
        this.timingInfo.addSubMeasurement(eventName, timingInfo.endTiming());
    }

    @Override
    public void endEvent(AWSRequestMetrics.Field f) {
        this.endEvent(f.name());
    }

    @Override
    public void incrementCounter(String event) {
        this.timingInfo.incrementCounter(event);
    }

    @Override
    public void incrementCounter(AWSRequestMetrics.Field f) {
        this.incrementCounter(f.name());
    }

    @Override
    public void setCounter(String counterName, long count) {
        this.timingInfo.setCounter(counterName, count);
    }

    @Override
    public void setCounter(AWSRequestMetrics.Field f, long count) {
        this.setCounter(f.name(), count);
    }

    @Override
    public void addProperty(String propertyName, Object value) {
        List<Object> propertyList = this.properties.get(propertyName);
        if (propertyList == null) {
            propertyList = new ArrayList<Object>();
            this.properties.put(propertyName, propertyList);
        }
        propertyList.add(value);
    }

    @Override
    public void addProperty(AWSRequestMetrics.Field f, Object value) {
        this.addProperty(f.name(), value);
    }

    @Override
    public void log() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<Object>> entry : this.properties.entrySet()) {
            this.keyValueFormat(entry.getKey(), entry.getValue(), builder);
        }
        for (Map.Entry<String, Object> entry : this.timingInfo.getAllCounters().entrySet()) {
            this.keyValueFormat(entry.getKey(), entry.getValue(), builder);
        }
        for (Map.Entry<String, Object> entry : this.timingInfo.getSubMeasurementsByName().entrySet()) {
            this.keyValueFormat(entry.getKey(), entry.getValue(), builder);
        }
        latencyLogger.info((Object)builder.toString());
    }

    private void keyValueFormat(Object key, Object value, StringBuilder builder) {
        builder.append(key).append(KEY_VALUE_SEPARATOR).append(value).append(COMMA_SEPARATOR);
    }

    @Override
    public List<Object> getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public List<Object> getProperty(AWSRequestMetrics.Field f) {
        return this.getProperty(f.name());
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }
}

