/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.TimingInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSRequestMetrics {
    private final TimingInfo timingInfo;
    private final boolean profilingSystemPropertyEnabled;
    private final Map<String, List<Object>> properties = new HashMap<String, List<Object>>();
    private final Map<String, TimingInfo> eventsBeingProfiled = new HashMap<String, TimingInfo>();
    private static final Log latencyLogger = LogFactory.getLog((String)"com.amazonaws.latency");
    private static final Object KEY_VALUE_SEPARATOR = "=";
    private static final Object COMMA_SEPARATOR = ", ";

    public AWSRequestMetrics() {
        this.timingInfo = TimingInfo.startTiming();
        this.profilingSystemPropertyEnabled = AWSRequestMetrics.isProfilingEnabled();
    }

    private static boolean isProfilingEnabled() {
        return System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null;
    }

    public void startEvent(String eventName) {
        if (this.profilingSystemPropertyEnabled) {
            this.eventsBeingProfiled.put(eventName, TimingInfo.startTiming(System.nanoTime()));
        }
    }

    public void endEvent(String eventName) {
        if (this.profilingSystemPropertyEnabled) {
            TimingInfo timingInfo = this.eventsBeingProfiled.get(eventName);
            if (timingInfo == null) {
                throw new IllegalStateException("Trying to end an event which was never started. " + eventName);
            }
            this.timingInfo.addSubMeasurement(eventName, timingInfo.endTiming());
        }
    }

    public void incrementCounter(String event) {
        if (this.profilingSystemPropertyEnabled) {
            this.timingInfo.incrementCounter(event);
        }
    }

    public void setCounter(String counterName, long count) {
        if (this.profilingSystemPropertyEnabled) {
            this.timingInfo.setCounter(counterName, count);
        }
    }

    public void addProperty(String propertyName, Object value) {
        List<Object> propertyList = this.properties.get(propertyName);
        if (propertyList == null) {
            propertyList = new ArrayList<Object>();
            this.properties.put(propertyName, propertyList);
        }
        propertyList.add(value);
    }

    public void log() {
        if (!this.profilingSystemPropertyEnabled) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<Object>> entry : this.properties.entrySet()) {
            this.keyValueFormat(entry.getKey(), entry.getValue(), builder);
        }
        for (Map.Entry<String, Object> entry : this.timingInfo.getAllCounters().entrySet()) {
            this.keyValueFormat(entry.getKey(), entry.getValue(), builder);
        }
        for (Map.Entry<String, Object> entry : this.timingInfo.getSubMeasurementsByName().entrySet()) {
            this.keyValueFormat(entry.getKey(), entry.getValue(), builder);
        }
        latencyLogger.info((Object)builder.toString());
    }

    private void keyValueFormat(Object key, Object value, StringBuilder builder) {
        builder.append(key).append(KEY_VALUE_SEPARATOR).append(value).append(COMMA_SEPARATOR);
    }

    public TimingInfo getTimingInfo() {
        return this.timingInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        StatusCode,
        AWSErrorCode,
        AWSRequestID,
        BytesProcessed,
        AttemptCount,
        ResponseProcessingTime,
        ClientExecuteTime,
        RequestSigningTime,
        HttpRequestTime,
        RequestMarshallTime,
        RetryPauseTime,
        RedirectLocation,
        Exception,
        CredentialsRequestTime,
        ServiceEndpoint,
        ServiceName;

    }
}

