/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyClusterRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String clusterIdentifier;
    private String clusterType;
    private String nodeType;
    private Integer numberOfNodes;
    private ListWithAutoConstructFlag<String> clusterSecurityGroups;
    private ListWithAutoConstructFlag<String> vpcSecurityGroupIds;
    private String masterUserPassword;
    private String clusterParameterGroupName;
    private Integer automatedSnapshotRetentionPeriod;
    private String preferredMaintenanceWindow;
    private String clusterVersion;
    private Boolean allowVersionUpgrade;

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public ModifyClusterRequest withClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
        return this;
    }

    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public ModifyClusterRequest withClusterType(String clusterType) {
        this.clusterType = clusterType;
        return this;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public ModifyClusterRequest withNodeType(String nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public ModifyClusterRequest withNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
        return this;
    }

    public List<String> getClusterSecurityGroups() {
        if (this.clusterSecurityGroups == null) {
            this.clusterSecurityGroups = new ListWithAutoConstructFlag();
            this.clusterSecurityGroups.setAutoConstruct(true);
        }
        return this.clusterSecurityGroups;
    }

    public void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
            return;
        }
        ListWithAutoConstructFlag clusterSecurityGroupsCopy = new ListWithAutoConstructFlag(clusterSecurityGroups.size());
        clusterSecurityGroupsCopy.addAll(clusterSecurityGroups);
        this.clusterSecurityGroups = clusterSecurityGroupsCopy;
    }

    public ModifyClusterRequest withClusterSecurityGroups(String ... clusterSecurityGroups) {
        if (this.getClusterSecurityGroups() == null) {
            this.setClusterSecurityGroups(new ArrayList<String>(clusterSecurityGroups.length));
        }
        for (String value : clusterSecurityGroups) {
            this.getClusterSecurityGroups().add(value);
        }
        return this;
    }

    public ModifyClusterRequest withClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
        } else {
            ListWithAutoConstructFlag clusterSecurityGroupsCopy = new ListWithAutoConstructFlag(clusterSecurityGroups.size());
            clusterSecurityGroupsCopy.addAll(clusterSecurityGroups);
            this.clusterSecurityGroups = clusterSecurityGroupsCopy;
        }
        return this;
    }

    public List<String> getVpcSecurityGroupIds() {
        if (this.vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = new ListWithAutoConstructFlag();
            this.vpcSecurityGroupIds.setAutoConstruct(true);
        }
        return this.vpcSecurityGroupIds;
    }

    public void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
            return;
        }
        ListWithAutoConstructFlag vpcSecurityGroupIdsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupIds.size());
        vpcSecurityGroupIdsCopy.addAll(vpcSecurityGroupIds);
        this.vpcSecurityGroupIds = vpcSecurityGroupIdsCopy;
    }

    public ModifyClusterRequest withVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
        if (this.getVpcSecurityGroupIds() == null) {
            this.setVpcSecurityGroupIds(new ArrayList<String>(vpcSecurityGroupIds.length));
        }
        for (String value : vpcSecurityGroupIds) {
            this.getVpcSecurityGroupIds().add(value);
        }
        return this;
    }

    public ModifyClusterRequest withVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
        if (vpcSecurityGroupIds == null) {
            this.vpcSecurityGroupIds = null;
        } else {
            ListWithAutoConstructFlag vpcSecurityGroupIdsCopy = new ListWithAutoConstructFlag(vpcSecurityGroupIds.size());
            vpcSecurityGroupIdsCopy.addAll(vpcSecurityGroupIds);
            this.vpcSecurityGroupIds = vpcSecurityGroupIdsCopy;
        }
        return this;
    }

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public ModifyClusterRequest withMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
        return this;
    }

    public String getClusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public void setClusterParameterGroupName(String clusterParameterGroupName) {
        this.clusterParameterGroupName = clusterParameterGroupName;
    }

    public ModifyClusterRequest withClusterParameterGroupName(String clusterParameterGroupName) {
        this.clusterParameterGroupName = clusterParameterGroupName;
        return this;
    }

    public Integer getAutomatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
    }

    public ModifyClusterRequest withAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public ModifyClusterRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public ModifyClusterRequest withClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
        return this;
    }

    public Boolean isAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
    }

    public ModifyClusterRequest withAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
        return this;
    }

    public Boolean getAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: " + this.getClusterIdentifier() + ",");
        }
        if (this.getClusterType() != null) {
            sb.append("ClusterType: " + this.getClusterType() + ",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: " + this.getNodeType() + ",");
        }
        if (this.getNumberOfNodes() != null) {
            sb.append("NumberOfNodes: " + this.getNumberOfNodes() + ",");
        }
        if (this.getClusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: " + this.getClusterSecurityGroups() + ",");
        }
        if (this.getVpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: " + this.getVpcSecurityGroupIds() + ",");
        }
        if (this.getMasterUserPassword() != null) {
            sb.append("MasterUserPassword: " + this.getMasterUserPassword() + ",");
        }
        if (this.getClusterParameterGroupName() != null) {
            sb.append("ClusterParameterGroupName: " + this.getClusterParameterGroupName() + ",");
        }
        if (this.getAutomatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: " + this.getAutomatedSnapshotRetentionPeriod() + ",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: " + this.getPreferredMaintenanceWindow() + ",");
        }
        if (this.getClusterVersion() != null) {
            sb.append("ClusterVersion: " + this.getClusterVersion() + ",");
        }
        if (this.isAllowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: " + this.isAllowVersionUpgrade());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getClusterType() == null ? 0 : this.getClusterType().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfNodes() == null ? 0 : this.getNumberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSecurityGroups() == null ? 0 : ((Object)this.getClusterSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupIds() == null ? 0 : ((Object)this.getVpcSecurityGroupIds()).hashCode());
        hashCode = 31 * hashCode + (this.getMasterUserPassword() == null ? 0 : this.getMasterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.getClusterParameterGroupName() == null ? 0 : this.getClusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatedSnapshotRetentionPeriod() == null ? 0 : this.getAutomatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getClusterVersion() == null ? 0 : this.getClusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.isAllowVersionUpgrade() == null ? 0 : this.isAllowVersionUpgrade().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterRequest)) {
            return false;
        }
        ModifyClusterRequest other = (ModifyClusterRequest)obj;
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getClusterType() == null ^ this.getClusterType() == null) {
            return false;
        }
        if (other.getClusterType() != null && !other.getClusterType().equals(this.getClusterType())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getNumberOfNodes() == null ^ this.getNumberOfNodes() == null) {
            return false;
        }
        if (other.getNumberOfNodes() != null && !other.getNumberOfNodes().equals(this.getNumberOfNodes())) {
            return false;
        }
        if (other.getClusterSecurityGroups() == null ^ this.getClusterSecurityGroups() == null) {
            return false;
        }
        if (other.getClusterSecurityGroups() != null && !((Object)other.getClusterSecurityGroups()).equals(this.getClusterSecurityGroups())) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() == null ^ this.getVpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupIds() != null && !((Object)other.getVpcSecurityGroupIds()).equals(this.getVpcSecurityGroupIds())) {
            return false;
        }
        if (other.getMasterUserPassword() == null ^ this.getMasterUserPassword() == null) {
            return false;
        }
        if (other.getMasterUserPassword() != null && !other.getMasterUserPassword().equals(this.getMasterUserPassword())) {
            return false;
        }
        if (other.getClusterParameterGroupName() == null ^ this.getClusterParameterGroupName() == null) {
            return false;
        }
        if (other.getClusterParameterGroupName() != null && !other.getClusterParameterGroupName().equals(this.getClusterParameterGroupName())) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() == null ^ this.getAutomatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() != null && !other.getAutomatedSnapshotRetentionPeriod().equals(this.getAutomatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getClusterVersion() == null ^ this.getClusterVersion() == null) {
            return false;
        }
        if (other.getClusterVersion() != null && !other.getClusterVersion().equals(this.getClusterVersion())) {
            return false;
        }
        if (other.isAllowVersionUpgrade() == null ^ this.isAllowVersionUpgrade() == null) {
            return false;
        }
        return other.isAllowVersionUpgrade() == null || other.isAllowVersionUpgrade().equals(this.isAllowVersionUpgrade());
    }
}

