/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionDetail;
import com.amazonaws.services.elasticmapreduce.model.JobFlowExecutionStatusDetail;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesDetail;
import com.amazonaws.services.elasticmapreduce.model.StepDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobFlowDetail
implements Serializable {
    private String jobFlowId;
    private String name;
    private String logUri;
    private String amiVersion;
    private JobFlowExecutionStatusDetail executionStatusDetail;
    private JobFlowInstancesDetail instances;
    private ListWithAutoConstructFlag<StepDetail> steps;
    private ListWithAutoConstructFlag<BootstrapActionDetail> bootstrapActions;
    private ListWithAutoConstructFlag<String> supportedProducts;
    private Boolean visibleToAllUsers;
    private String jobFlowRole;

    public JobFlowDetail() {
    }

    public JobFlowDetail(String jobFlowId, String name, JobFlowExecutionStatusDetail executionStatusDetail, JobFlowInstancesDetail instances) {
        this.setJobFlowId(jobFlowId);
        this.setName(name);
        this.setExecutionStatusDetail(executionStatusDetail);
        this.setInstances(instances);
    }

    public String getJobFlowId() {
        return this.jobFlowId;
    }

    public void setJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
    }

    public JobFlowDetail withJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobFlowDetail withName(String name) {
        this.name = name;
        return this;
    }

    public String getLogUri() {
        return this.logUri;
    }

    public void setLogUri(String logUri) {
        this.logUri = logUri;
    }

    public JobFlowDetail withLogUri(String logUri) {
        this.logUri = logUri;
        return this;
    }

    public String getAmiVersion() {
        return this.amiVersion;
    }

    public void setAmiVersion(String amiVersion) {
        this.amiVersion = amiVersion;
    }

    public JobFlowDetail withAmiVersion(String amiVersion) {
        this.amiVersion = amiVersion;
        return this;
    }

    public JobFlowExecutionStatusDetail getExecutionStatusDetail() {
        return this.executionStatusDetail;
    }

    public void setExecutionStatusDetail(JobFlowExecutionStatusDetail executionStatusDetail) {
        this.executionStatusDetail = executionStatusDetail;
    }

    public JobFlowDetail withExecutionStatusDetail(JobFlowExecutionStatusDetail executionStatusDetail) {
        this.executionStatusDetail = executionStatusDetail;
        return this;
    }

    public JobFlowInstancesDetail getInstances() {
        return this.instances;
    }

    public void setInstances(JobFlowInstancesDetail instances) {
        this.instances = instances;
    }

    public JobFlowDetail withInstances(JobFlowInstancesDetail instances) {
        this.instances = instances;
        return this;
    }

    public List<StepDetail> getSteps() {
        if (this.steps == null) {
            this.steps = new ListWithAutoConstructFlag();
            this.steps.setAutoConstruct(true);
        }
        return this.steps;
    }

    public void setSteps(Collection<StepDetail> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        ListWithAutoConstructFlag stepsCopy = new ListWithAutoConstructFlag(steps.size());
        stepsCopy.addAll(steps);
        this.steps = stepsCopy;
    }

    public JobFlowDetail withSteps(StepDetail ... steps) {
        if (this.getSteps() == null) {
            this.setSteps(new ArrayList<StepDetail>(steps.length));
        }
        for (StepDetail value : steps) {
            this.getSteps().add(value);
        }
        return this;
    }

    public JobFlowDetail withSteps(Collection<StepDetail> steps) {
        if (steps == null) {
            this.steps = null;
        } else {
            ListWithAutoConstructFlag stepsCopy = new ListWithAutoConstructFlag(steps.size());
            stepsCopy.addAll(steps);
            this.steps = stepsCopy;
        }
        return this;
    }

    public List<BootstrapActionDetail> getBootstrapActions() {
        if (this.bootstrapActions == null) {
            this.bootstrapActions = new ListWithAutoConstructFlag();
            this.bootstrapActions.setAutoConstruct(true);
        }
        return this.bootstrapActions;
    }

    public void setBootstrapActions(Collection<BootstrapActionDetail> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
            return;
        }
        ListWithAutoConstructFlag bootstrapActionsCopy = new ListWithAutoConstructFlag(bootstrapActions.size());
        bootstrapActionsCopy.addAll(bootstrapActions);
        this.bootstrapActions = bootstrapActionsCopy;
    }

    public JobFlowDetail withBootstrapActions(BootstrapActionDetail ... bootstrapActions) {
        if (this.getBootstrapActions() == null) {
            this.setBootstrapActions(new ArrayList<BootstrapActionDetail>(bootstrapActions.length));
        }
        for (BootstrapActionDetail value : bootstrapActions) {
            this.getBootstrapActions().add(value);
        }
        return this;
    }

    public JobFlowDetail withBootstrapActions(Collection<BootstrapActionDetail> bootstrapActions) {
        if (bootstrapActions == null) {
            this.bootstrapActions = null;
        } else {
            ListWithAutoConstructFlag bootstrapActionsCopy = new ListWithAutoConstructFlag(bootstrapActions.size());
            bootstrapActionsCopy.addAll(bootstrapActions);
            this.bootstrapActions = bootstrapActionsCopy;
        }
        return this;
    }

    public List<String> getSupportedProducts() {
        if (this.supportedProducts == null) {
            this.supportedProducts = new ListWithAutoConstructFlag();
            this.supportedProducts.setAutoConstruct(true);
        }
        return this.supportedProducts;
    }

    public void setSupportedProducts(Collection<String> supportedProducts) {
        if (supportedProducts == null) {
            this.supportedProducts = null;
            return;
        }
        ListWithAutoConstructFlag supportedProductsCopy = new ListWithAutoConstructFlag(supportedProducts.size());
        supportedProductsCopy.addAll(supportedProducts);
        this.supportedProducts = supportedProductsCopy;
    }

    public JobFlowDetail withSupportedProducts(String ... supportedProducts) {
        if (this.getSupportedProducts() == null) {
            this.setSupportedProducts(new ArrayList<String>(supportedProducts.length));
        }
        for (String value : supportedProducts) {
            this.getSupportedProducts().add(value);
        }
        return this;
    }

    public JobFlowDetail withSupportedProducts(Collection<String> supportedProducts) {
        if (supportedProducts == null) {
            this.supportedProducts = null;
        } else {
            ListWithAutoConstructFlag supportedProductsCopy = new ListWithAutoConstructFlag(supportedProducts.size());
            supportedProductsCopy.addAll(supportedProducts);
            this.supportedProducts = supportedProductsCopy;
        }
        return this;
    }

    public Boolean isVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public void setVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
    }

    public JobFlowDetail withVisibleToAllUsers(Boolean visibleToAllUsers) {
        this.visibleToAllUsers = visibleToAllUsers;
        return this;
    }

    public Boolean getVisibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public String getJobFlowRole() {
        return this.jobFlowRole;
    }

    public void setJobFlowRole(String jobFlowRole) {
        this.jobFlowRole = jobFlowRole;
    }

    public JobFlowDetail withJobFlowRole(String jobFlowRole) {
        this.jobFlowRole = jobFlowRole;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobFlowId() != null) {
            sb.append("JobFlowId: " + this.getJobFlowId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getLogUri() != null) {
            sb.append("LogUri: " + this.getLogUri() + ",");
        }
        if (this.getAmiVersion() != null) {
            sb.append("AmiVersion: " + this.getAmiVersion() + ",");
        }
        if (this.getExecutionStatusDetail() != null) {
            sb.append("ExecutionStatusDetail: " + this.getExecutionStatusDetail() + ",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: " + this.getSteps() + ",");
        }
        if (this.getBootstrapActions() != null) {
            sb.append("BootstrapActions: " + this.getBootstrapActions() + ",");
        }
        if (this.getSupportedProducts() != null) {
            sb.append("SupportedProducts: " + this.getSupportedProducts() + ",");
        }
        if (this.isVisibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: " + this.isVisibleToAllUsers() + ",");
        }
        if (this.getJobFlowRole() != null) {
            sb.append("JobFlowRole: " + this.getJobFlowRole());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobFlowId() == null ? 0 : this.getJobFlowId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getLogUri() == null ? 0 : this.getLogUri().hashCode());
        hashCode = 31 * hashCode + (this.getAmiVersion() == null ? 0 : this.getAmiVersion().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionStatusDetail() == null ? 0 : this.getExecutionStatusDetail().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : ((Object)this.getSteps()).hashCode());
        hashCode = 31 * hashCode + (this.getBootstrapActions() == null ? 0 : ((Object)this.getBootstrapActions()).hashCode());
        hashCode = 31 * hashCode + (this.getSupportedProducts() == null ? 0 : ((Object)this.getSupportedProducts()).hashCode());
        hashCode = 31 * hashCode + (this.isVisibleToAllUsers() == null ? 0 : this.isVisibleToAllUsers().hashCode());
        hashCode = 31 * hashCode + (this.getJobFlowRole() == null ? 0 : this.getJobFlowRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowDetail)) {
            return false;
        }
        JobFlowDetail other = (JobFlowDetail)obj;
        if (other.getJobFlowId() == null ^ this.getJobFlowId() == null) {
            return false;
        }
        if (other.getJobFlowId() != null && !other.getJobFlowId().equals(this.getJobFlowId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getLogUri() == null ^ this.getLogUri() == null) {
            return false;
        }
        if (other.getLogUri() != null && !other.getLogUri().equals(this.getLogUri())) {
            return false;
        }
        if (other.getAmiVersion() == null ^ this.getAmiVersion() == null) {
            return false;
        }
        if (other.getAmiVersion() != null && !other.getAmiVersion().equals(this.getAmiVersion())) {
            return false;
        }
        if (other.getExecutionStatusDetail() == null ^ this.getExecutionStatusDetail() == null) {
            return false;
        }
        if (other.getExecutionStatusDetail() != null && !other.getExecutionStatusDetail().equals(this.getExecutionStatusDetail())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !((Object)other.getSteps()).equals(this.getSteps())) {
            return false;
        }
        if (other.getBootstrapActions() == null ^ this.getBootstrapActions() == null) {
            return false;
        }
        if (other.getBootstrapActions() != null && !((Object)other.getBootstrapActions()).equals(this.getBootstrapActions())) {
            return false;
        }
        if (other.getSupportedProducts() == null ^ this.getSupportedProducts() == null) {
            return false;
        }
        if (other.getSupportedProducts() != null && !((Object)other.getSupportedProducts()).equals(this.getSupportedProducts())) {
            return false;
        }
        if (other.isVisibleToAllUsers() == null ^ this.isVisibleToAllUsers() == null) {
            return false;
        }
        if (other.isVisibleToAllUsers() != null && !other.isVisibleToAllUsers().equals(this.isVisibleToAllUsers())) {
            return false;
        }
        if (other.getJobFlowRole() == null ^ this.getJobFlowRole() == null) {
            return false;
        }
        return other.getJobFlowRole() == null || other.getJobFlowRole().equals(this.getJobFlowRole());
    }
}

