/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCacheRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String gatewayARN;
    private ListWithAutoConstructFlag<String> diskIds;

    public String getGatewayARN() {
        return this.gatewayARN;
    }

    public void setGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
    }

    public AddCacheRequest withGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
        return this;
    }

    public List<String> getDiskIds() {
        if (this.diskIds == null) {
            this.diskIds = new ListWithAutoConstructFlag();
            this.diskIds.setAutoConstruct(true);
        }
        return this.diskIds;
    }

    public void setDiskIds(Collection<String> diskIds) {
        if (diskIds == null) {
            this.diskIds = null;
            return;
        }
        ListWithAutoConstructFlag diskIdsCopy = new ListWithAutoConstructFlag(diskIds.size());
        diskIdsCopy.addAll(diskIds);
        this.diskIds = diskIdsCopy;
    }

    public AddCacheRequest withDiskIds(String ... diskIds) {
        if (this.getDiskIds() == null) {
            this.setDiskIds(new ArrayList<String>(diskIds.length));
        }
        for (String value : diskIds) {
            this.getDiskIds().add(value);
        }
        return this;
    }

    public AddCacheRequest withDiskIds(Collection<String> diskIds) {
        if (diskIds == null) {
            this.diskIds = null;
        } else {
            ListWithAutoConstructFlag diskIdsCopy = new ListWithAutoConstructFlag(diskIds.size());
            diskIdsCopy.addAll(diskIds);
            this.diskIds = diskIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGatewayARN() != null) {
            sb.append("GatewayARN: " + this.getGatewayARN() + ",");
        }
        if (this.getDiskIds() != null) {
            sb.append("DiskIds: " + this.getDiskIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGatewayARN() == null ? 0 : this.getGatewayARN().hashCode());
        hashCode = 31 * hashCode + (this.getDiskIds() == null ? 0 : ((Object)this.getDiskIds()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddCacheRequest)) {
            return false;
        }
        AddCacheRequest other = (AddCacheRequest)obj;
        if (other.getGatewayARN() == null ^ this.getGatewayARN() == null) {
            return false;
        }
        if (other.getGatewayARN() != null && !other.getGatewayARN().equals(this.getGatewayARN())) {
            return false;
        }
        if (other.getDiskIds() == null ^ this.getDiskIds() == null) {
            return false;
        }
        return other.getDiskIds() == null || ((Object)other.getDiskIds()).equals(this.getDiskIds());
    }
}

