/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeAddressesRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeAddressesRequest
extends AmazonWebServiceRequest
implements Serializable,
DryRunSupportedRequest<DescribeAddressesRequest> {
    private ListWithAutoConstructFlag<String> publicIps;
    private ListWithAutoConstructFlag<Filter> filters;
    private ListWithAutoConstructFlag<String> allocationIds;

    public List<String> getPublicIps() {
        if (this.publicIps == null) {
            this.publicIps = new ListWithAutoConstructFlag();
            this.publicIps.setAutoConstruct(true);
        }
        return this.publicIps;
    }

    public void setPublicIps(Collection<String> publicIps) {
        if (publicIps == null) {
            this.publicIps = null;
            return;
        }
        ListWithAutoConstructFlag publicIpsCopy = new ListWithAutoConstructFlag(publicIps.size());
        publicIpsCopy.addAll(publicIps);
        this.publicIps = publicIpsCopy;
    }

    public DescribeAddressesRequest withPublicIps(String ... publicIps) {
        if (this.getPublicIps() == null) {
            this.setPublicIps(new ArrayList<String>(publicIps.length));
        }
        for (String value : publicIps) {
            this.getPublicIps().add(value);
        }
        return this;
    }

    public DescribeAddressesRequest withPublicIps(Collection<String> publicIps) {
        if (publicIps == null) {
            this.publicIps = null;
        } else {
            ListWithAutoConstructFlag publicIpsCopy = new ListWithAutoConstructFlag(publicIps.size());
            publicIpsCopy.addAll(publicIps);
            this.publicIps = publicIpsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeAddressesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeAddressesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public List<String> getAllocationIds() {
        if (this.allocationIds == null) {
            this.allocationIds = new ListWithAutoConstructFlag();
            this.allocationIds.setAutoConstruct(true);
        }
        return this.allocationIds;
    }

    public void setAllocationIds(Collection<String> allocationIds) {
        if (allocationIds == null) {
            this.allocationIds = null;
            return;
        }
        ListWithAutoConstructFlag allocationIdsCopy = new ListWithAutoConstructFlag(allocationIds.size());
        allocationIdsCopy.addAll(allocationIds);
        this.allocationIds = allocationIdsCopy;
    }

    public DescribeAddressesRequest withAllocationIds(String ... allocationIds) {
        if (this.getAllocationIds() == null) {
            this.setAllocationIds(new ArrayList<String>(allocationIds.length));
        }
        for (String value : allocationIds) {
            this.getAllocationIds().add(value);
        }
        return this;
    }

    public DescribeAddressesRequest withAllocationIds(Collection<String> allocationIds) {
        if (allocationIds == null) {
            this.allocationIds = null;
        } else {
            ListWithAutoConstructFlag allocationIdsCopy = new ListWithAutoConstructFlag(allocationIds.size());
            allocationIdsCopy.addAll(allocationIds);
            this.allocationIds = allocationIdsCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeAddressesRequest> getDryRunRequest() {
        Request<DescribeAddressesRequest> request = new DescribeAddressesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPublicIps() != null) {
            sb.append("PublicIps: " + this.getPublicIps() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getAllocationIds() != null) {
            sb.append("AllocationIds: " + this.getAllocationIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPublicIps() == null ? 0 : ((Object)this.getPublicIps()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        hashCode = 31 * hashCode + (this.getAllocationIds() == null ? 0 : ((Object)this.getAllocationIds()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesRequest)) {
            return false;
        }
        DescribeAddressesRequest other = (DescribeAddressesRequest)obj;
        if (other.getPublicIps() == null ^ this.getPublicIps() == null) {
            return false;
        }
        if (other.getPublicIps() != null && !((Object)other.getPublicIps()).equals(this.getPublicIps())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !((Object)other.getFilters()).equals(this.getFilters())) {
            return false;
        }
        if (other.getAllocationIds() == null ^ this.getAllocationIds() == null) {
            return false;
        }
        return other.getAllocationIds() == null || ((Object)other.getAllocationIds()).equals(this.getAllocationIds());
    }
}

