/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineObject
implements Serializable {
    private String id;
    private String name;
    private ListWithAutoConstructFlag<Field> fields;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PipelineObject withId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PipelineObject withName(String name) {
        this.name = name;
        return this;
    }

    public List<Field> getFields() {
        if (this.fields == null) {
            this.fields = new ListWithAutoConstructFlag();
            this.fields.setAutoConstruct(true);
        }
        return this.fields;
    }

    public void setFields(Collection<Field> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        ListWithAutoConstructFlag fieldsCopy = new ListWithAutoConstructFlag(fields.size());
        fieldsCopy.addAll(fields);
        this.fields = fieldsCopy;
    }

    public PipelineObject withFields(Field ... fields) {
        if (this.getFields() == null) {
            this.setFields(new ArrayList<Field>(fields.length));
        }
        for (Field value : fields) {
            this.getFields().add(value);
        }
        return this;
    }

    public PipelineObject withFields(Collection<Field> fields) {
        if (fields == null) {
            this.fields = null;
        } else {
            ListWithAutoConstructFlag fieldsCopy = new ListWithAutoConstructFlag(fields.size());
            fieldsCopy.addAll(fields);
            this.fields = fieldsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: " + this.getId() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: " + this.getFields());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : ((Object)this.getFields()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineObject)) {
            return false;
        }
        PipelineObject other = (PipelineObject)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        return other.getFields() == null || ((Object)other.getFields()).equals(this.getFields());
    }
}

