/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentitySummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFrontOriginAccessIdentityList
implements Serializable {
    private String marker;
    private String nextMarker;
    private Integer maxItems;
    private Boolean isTruncated;
    private Integer quantity;
    private ListWithAutoConstructFlag<CloudFrontOriginAccessIdentitySummary> items;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public CloudFrontOriginAccessIdentityList withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public CloudFrontOriginAccessIdentityList withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public CloudFrontOriginAccessIdentityList withMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public CloudFrontOriginAccessIdentityList withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public CloudFrontOriginAccessIdentityList withQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public List<CloudFrontOriginAccessIdentitySummary> getItems() {
        if (this.items == null) {
            this.items = new ListWithAutoConstructFlag();
            this.items.setAutoConstruct(true);
        }
        return this.items;
    }

    public void setItems(Collection<CloudFrontOriginAccessIdentitySummary> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public CloudFrontOriginAccessIdentityList withItems(CloudFrontOriginAccessIdentitySummary ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<CloudFrontOriginAccessIdentitySummary>(items.length));
        }
        for (CloudFrontOriginAccessIdentitySummary value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public CloudFrontOriginAccessIdentityList withItems(Collection<CloudFrontOriginAccessIdentitySummary> items) {
        if (items == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: " + this.getMaxItems() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getQuantity() != null) {
            sb.append("Quantity: " + this.getQuantity() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentityList)) {
            return false;
        }
        CloudFrontOriginAccessIdentityList other = (CloudFrontOriginAccessIdentityList)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        if (other.getMaxItems() != null && !other.getMaxItems().equals(this.getMaxItems())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return other.getItems() == null || ((Object)other.getItems()).equals(this.getItems());
    }
}

