/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeDhcpOptionsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ListWithAutoConstructFlag<String> dhcpOptionsIds;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getDhcpOptionsIds() {
        if (this.dhcpOptionsIds == null) {
            this.dhcpOptionsIds = new ListWithAutoConstructFlag();
            this.dhcpOptionsIds.setAutoConstruct(true);
        }
        return this.dhcpOptionsIds;
    }

    public void setDhcpOptionsIds(Collection<String> dhcpOptionsIds) {
        if (dhcpOptionsIds == null) {
            this.dhcpOptionsIds = null;
            return;
        }
        ListWithAutoConstructFlag dhcpOptionsIdsCopy = new ListWithAutoConstructFlag(dhcpOptionsIds.size());
        dhcpOptionsIdsCopy.addAll(dhcpOptionsIds);
        this.dhcpOptionsIds = dhcpOptionsIdsCopy;
    }

    public DescribeDhcpOptionsRequest withDhcpOptionsIds(String ... dhcpOptionsIds) {
        if (this.getDhcpOptionsIds() == null) {
            this.setDhcpOptionsIds(new ArrayList<String>(dhcpOptionsIds.length));
        }
        for (String value : dhcpOptionsIds) {
            this.getDhcpOptionsIds().add(value);
        }
        return this;
    }

    public DescribeDhcpOptionsRequest withDhcpOptionsIds(Collection<String> dhcpOptionsIds) {
        if (dhcpOptionsIds == null) {
            this.dhcpOptionsIds = null;
        } else {
            ListWithAutoConstructFlag dhcpOptionsIdsCopy = new ListWithAutoConstructFlag(dhcpOptionsIds.size());
            dhcpOptionsIdsCopy.addAll(dhcpOptionsIds);
            this.dhcpOptionsIds = dhcpOptionsIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeDhcpOptionsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeDhcpOptionsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDhcpOptionsIds() != null) {
            sb.append("DhcpOptionsIds: " + this.getDhcpOptionsIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDhcpOptionsIds() == null ? 0 : ((Object)this.getDhcpOptionsIds()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsRequest)) {
            return false;
        }
        DescribeDhcpOptionsRequest other = (DescribeDhcpOptionsRequest)obj;
        if (other.getDhcpOptionsIds() == null ^ this.getDhcpOptionsIds() == null) {
            return false;
        }
        if (other.getDhcpOptionsIds() != null && !((Object)other.getDhcpOptionsIds()).equals(this.getDhcpOptionsIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || ((Object)other.getFilters()).equals(this.getFilters());
    }
}

