/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.support.AWSSupport;
import com.amazonaws.services.support.model.AddCommunicationToCaseRequest;
import com.amazonaws.services.support.model.AddCommunicationToCaseResult;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.services.support.model.CreateCaseResult;
import com.amazonaws.services.support.model.DescribeCasesRequest;
import com.amazonaws.services.support.model.DescribeCasesResult;
import com.amazonaws.services.support.model.DescribeCommunicationsRequest;
import com.amazonaws.services.support.model.DescribeCommunicationsResult;
import com.amazonaws.services.support.model.DescribeServicesRequest;
import com.amazonaws.services.support.model.DescribeServicesResult;
import com.amazonaws.services.support.model.DescribeSeverityLevelsRequest;
import com.amazonaws.services.support.model.DescribeSeverityLevelsResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckResultResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorCheckSummariesResult;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksRequest;
import com.amazonaws.services.support.model.DescribeTrustedAdvisorChecksResult;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckRequest;
import com.amazonaws.services.support.model.RefreshTrustedAdvisorCheckResult;
import com.amazonaws.services.support.model.ResolveCaseRequest;
import com.amazonaws.services.support.model.ResolveCaseResult;
import com.amazonaws.services.support.model.transform.AddCommunicationToCaseRequestMarshaller;
import com.amazonaws.services.support.model.transform.AddCommunicationToCaseResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.CaseCreationLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.support.model.transform.CaseIdNotFoundExceptionUnmarshaller;
import com.amazonaws.services.support.model.transform.CreateCaseRequestMarshaller;
import com.amazonaws.services.support.model.transform.CreateCaseResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeCasesRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeCasesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeCommunicationsRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeCommunicationsResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeServicesRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeServicesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeSeverityLevelsRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeSeverityLevelsResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckRefreshStatusesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckResultRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckResultResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckSummariesRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorCheckSummariesResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorChecksRequestMarshaller;
import com.amazonaws.services.support.model.transform.DescribeTrustedAdvisorChecksResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.support.model.transform.RefreshTrustedAdvisorCheckRequestMarshaller;
import com.amazonaws.services.support.model.transform.RefreshTrustedAdvisorCheckResultJsonUnmarshaller;
import com.amazonaws.services.support.model.transform.ResolveCaseRequestMarshaller;
import com.amazonaws.services.support.model.transform.ResolveCaseResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSSupportClient
extends AmazonWebServiceClient
implements AWSSupport {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSupport.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AWSSupportClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSSupportClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSSupportClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSSupportClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSSupportClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSSupportClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new CaseCreationLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CaseIdNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("support.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("support");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/support/request.handlers"));
    }

    @Override
    public DescribeCasesResult describeCases(DescribeCasesRequest describeCasesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeCasesRequest> request = new DescribeCasesRequestMarshaller().marshall(describeCasesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeCasesResultJsonUnmarshaller unmarshaller = new DescribeCasesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeCasesResult> responseHandler = new JsonResponseHandler<DescribeCasesResult>(unmarshaller);
        return (DescribeCasesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeTrustedAdvisorCheckRefreshStatusesResult describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest describeTrustedAdvisorCheckRefreshStatusesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeTrustedAdvisorCheckRefreshStatusesRequest> request = new DescribeTrustedAdvisorCheckRefreshStatusesRequestMarshaller().marshall(describeTrustedAdvisorCheckRefreshStatusesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeTrustedAdvisorCheckRefreshStatusesResultJsonUnmarshaller unmarshaller = new DescribeTrustedAdvisorCheckRefreshStatusesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeTrustedAdvisorCheckRefreshStatusesResult> responseHandler = new JsonResponseHandler<DescribeTrustedAdvisorCheckRefreshStatusesResult>(unmarshaller);
        return (DescribeTrustedAdvisorCheckRefreshStatusesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeSeverityLevelsResult describeSeverityLevels(DescribeSeverityLevelsRequest describeSeverityLevelsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeSeverityLevelsRequest> request = new DescribeSeverityLevelsRequestMarshaller().marshall(describeSeverityLevelsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeSeverityLevelsResultJsonUnmarshaller unmarshaller = new DescribeSeverityLevelsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeSeverityLevelsResult> responseHandler = new JsonResponseHandler<DescribeSeverityLevelsResult>(unmarshaller);
        return (DescribeSeverityLevelsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeCommunicationsResult describeCommunications(DescribeCommunicationsRequest describeCommunicationsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeCommunicationsRequest> request = new DescribeCommunicationsRequestMarshaller().marshall(describeCommunicationsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeCommunicationsResultJsonUnmarshaller unmarshaller = new DescribeCommunicationsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeCommunicationsResult> responseHandler = new JsonResponseHandler<DescribeCommunicationsResult>(unmarshaller);
        return (DescribeCommunicationsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public AddCommunicationToCaseResult addCommunicationToCase(AddCommunicationToCaseRequest addCommunicationToCaseRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<AddCommunicationToCaseRequest> request = new AddCommunicationToCaseRequestMarshaller().marshall(addCommunicationToCaseRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        AddCommunicationToCaseResultJsonUnmarshaller unmarshaller = new AddCommunicationToCaseResultJsonUnmarshaller();
        JsonResponseHandler<AddCommunicationToCaseResult> responseHandler = new JsonResponseHandler<AddCommunicationToCaseResult>(unmarshaller);
        return (AddCommunicationToCaseResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreateCaseResult createCase(CreateCaseRequest createCaseRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreateCaseRequest> request = new CreateCaseRequestMarshaller().marshall(createCaseRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreateCaseResultJsonUnmarshaller unmarshaller = new CreateCaseResultJsonUnmarshaller();
        JsonResponseHandler<CreateCaseResult> responseHandler = new JsonResponseHandler<CreateCaseResult>(unmarshaller);
        return (CreateCaseResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeTrustedAdvisorChecksResult describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest describeTrustedAdvisorChecksRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeTrustedAdvisorChecksRequest> request = new DescribeTrustedAdvisorChecksRequestMarshaller().marshall(describeTrustedAdvisorChecksRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeTrustedAdvisorChecksResultJsonUnmarshaller unmarshaller = new DescribeTrustedAdvisorChecksResultJsonUnmarshaller();
        JsonResponseHandler<DescribeTrustedAdvisorChecksResult> responseHandler = new JsonResponseHandler<DescribeTrustedAdvisorChecksResult>(unmarshaller);
        return (DescribeTrustedAdvisorChecksResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeTrustedAdvisorCheckResultResult describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest describeTrustedAdvisorCheckResultRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeTrustedAdvisorCheckResultRequest> request = new DescribeTrustedAdvisorCheckResultRequestMarshaller().marshall(describeTrustedAdvisorCheckResultRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeTrustedAdvisorCheckResultResultJsonUnmarshaller unmarshaller = new DescribeTrustedAdvisorCheckResultResultJsonUnmarshaller();
        JsonResponseHandler<DescribeTrustedAdvisorCheckResultResult> responseHandler = new JsonResponseHandler<DescribeTrustedAdvisorCheckResultResult>(unmarshaller);
        return (DescribeTrustedAdvisorCheckResultResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ResolveCaseResult resolveCase(ResolveCaseRequest resolveCaseRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ResolveCaseRequest> request = new ResolveCaseRequestMarshaller().marshall(resolveCaseRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ResolveCaseResultJsonUnmarshaller unmarshaller = new ResolveCaseResultJsonUnmarshaller();
        JsonResponseHandler<ResolveCaseResult> responseHandler = new JsonResponseHandler<ResolveCaseResult>(unmarshaller);
        return (ResolveCaseResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public RefreshTrustedAdvisorCheckResult refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest refreshTrustedAdvisorCheckRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<RefreshTrustedAdvisorCheckRequest> request = new RefreshTrustedAdvisorCheckRequestMarshaller().marshall(refreshTrustedAdvisorCheckRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        RefreshTrustedAdvisorCheckResultJsonUnmarshaller unmarshaller = new RefreshTrustedAdvisorCheckResultJsonUnmarshaller();
        JsonResponseHandler<RefreshTrustedAdvisorCheckResult> responseHandler = new JsonResponseHandler<RefreshTrustedAdvisorCheckResult>(unmarshaller);
        return (RefreshTrustedAdvisorCheckResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeServicesResult describeServices(DescribeServicesRequest describeServicesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeServicesRequest> request = new DescribeServicesRequestMarshaller().marshall(describeServicesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeServicesResultJsonUnmarshaller unmarshaller = new DescribeServicesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeServicesResult> responseHandler = new JsonResponseHandler<DescribeServicesResult>(unmarshaller);
        return (DescribeServicesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeTrustedAdvisorCheckSummariesResult describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest describeTrustedAdvisorCheckSummariesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeTrustedAdvisorCheckSummariesRequest> request = new DescribeTrustedAdvisorCheckSummariesRequestMarshaller().marshall(describeTrustedAdvisorCheckSummariesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeTrustedAdvisorCheckSummariesResultJsonUnmarshaller unmarshaller = new DescribeTrustedAdvisorCheckSummariesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeTrustedAdvisorCheckSummariesResult> responseHandler = new JsonResponseHandler<DescribeTrustedAdvisorCheckSummariesResult>(unmarshaller);
        return (DescribeTrustedAdvisorCheckSummariesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeCasesResult describeCases() throws AmazonServiceException, AmazonClientException {
        return this.describeCases(new DescribeCasesRequest());
    }

    @Override
    public DescribeSeverityLevelsResult describeSeverityLevels() throws AmazonServiceException, AmazonClientException {
        return this.describeSeverityLevels(new DescribeSeverityLevelsRequest());
    }

    @Override
    public ResolveCaseResult resolveCase() throws AmazonServiceException, AmazonClientException {
        return this.resolveCase(new ResolveCaseRequest());
    }

    @Override
    public DescribeServicesResult describeServices() throws AmazonServiceException, AmazonClientException {
        return this.describeServices(new DescribeServicesRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "${region.lookup.name}";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        awsRequestMetrics.log();
        return (X)result;
    }
}

