/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.AppType;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.SslConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class App
implements Serializable {
    private String appId;
    private String stackId;
    private String shortname;
    private String name;
    private String description;
    private String type;
    private Source appSource;
    private ListWithAutoConstructFlag<String> domains;
    private Boolean enableSsl;
    private SslConfiguration sslConfiguration;
    private Map<String, String> attributes;
    private String createdAt;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public App withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String getStackId() {
        return this.stackId;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public App withStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    public String getShortname() {
        return this.shortname;
    }

    public void setShortname(String shortname) {
        this.shortname = shortname;
    }

    public App withShortname(String shortname) {
        this.shortname = shortname;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public App withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public App withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public App withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(AppType type) {
        this.type = type.toString();
    }

    public App withType(AppType type) {
        this.type = type.toString();
        return this;
    }

    public Source getAppSource() {
        return this.appSource;
    }

    public void setAppSource(Source appSource) {
        this.appSource = appSource;
    }

    public App withAppSource(Source appSource) {
        this.appSource = appSource;
        return this;
    }

    public List<String> getDomains() {
        if (this.domains == null) {
            this.domains = new ListWithAutoConstructFlag();
            this.domains.setAutoConstruct(true);
        }
        return this.domains;
    }

    public void setDomains(Collection<String> domains) {
        if (domains == null) {
            this.domains = null;
            return;
        }
        ListWithAutoConstructFlag domainsCopy = new ListWithAutoConstructFlag(domains.size());
        domainsCopy.addAll(domains);
        this.domains = domainsCopy;
    }

    public App withDomains(String ... domains) {
        if (this.getDomains() == null) {
            this.setDomains(new ArrayList<String>(domains.length));
        }
        for (String value : domains) {
            this.getDomains().add(value);
        }
        return this;
    }

    public App withDomains(Collection<String> domains) {
        if (domains == null) {
            this.domains = null;
        } else {
            ListWithAutoConstructFlag domainsCopy = new ListWithAutoConstructFlag(domains.size());
            domainsCopy.addAll(domains);
            this.domains = domainsCopy;
        }
        return this;
    }

    public Boolean isEnableSsl() {
        return this.enableSsl;
    }

    public void setEnableSsl(Boolean enableSsl) {
        this.enableSsl = enableSsl;
    }

    public App withEnableSsl(Boolean enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Boolean getEnableSsl() {
        return this.enableSsl;
    }

    public SslConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public void setSslConfiguration(SslConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public App withSslConfiguration(SslConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public App withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public App withCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppId() != null) {
            sb.append("AppId: " + this.getAppId() + ",");
        }
        if (this.getStackId() != null) {
            sb.append("StackId: " + this.getStackId() + ",");
        }
        if (this.getShortname() != null) {
            sb.append("Shortname: " + this.getShortname() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ",");
        }
        if (this.getAppSource() != null) {
            sb.append("AppSource: " + this.getAppSource() + ",");
        }
        if (this.getDomains() != null) {
            sb.append("Domains: " + this.getDomains() + ",");
        }
        if (this.isEnableSsl() != null) {
            sb.append("EnableSsl: " + this.isEnableSsl() + ",");
        }
        if (this.getSslConfiguration() != null) {
            sb.append("SslConfiguration: " + this.getSslConfiguration() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: " + this.getCreatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppId() == null ? 0 : this.getAppId().hashCode());
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getShortname() == null ? 0 : this.getShortname().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getAppSource() == null ? 0 : this.getAppSource().hashCode());
        hashCode = 31 * hashCode + (this.getDomains() == null ? 0 : ((Object)this.getDomains()).hashCode());
        hashCode = 31 * hashCode + (this.isEnableSsl() == null ? 0 : this.isEnableSsl().hashCode());
        hashCode = 31 * hashCode + (this.getSslConfiguration() == null ? 0 : this.getSslConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : ((Object)this.getAttributes()).hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App)obj;
        if (other.getAppId() == null ^ this.getAppId() == null) {
            return false;
        }
        if (other.getAppId() != null && !other.getAppId().equals(this.getAppId())) {
            return false;
        }
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getShortname() == null ^ this.getShortname() == null) {
            return false;
        }
        if (other.getShortname() != null && !other.getShortname().equals(this.getShortname())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getAppSource() == null ^ this.getAppSource() == null) {
            return false;
        }
        if (other.getAppSource() != null && !other.getAppSource().equals(this.getAppSource())) {
            return false;
        }
        if (other.getDomains() == null ^ this.getDomains() == null) {
            return false;
        }
        if (other.getDomains() != null && !((Object)other.getDomains()).equals(this.getDomains())) {
            return false;
        }
        if (other.isEnableSsl() == null ^ this.isEnableSsl() == null) {
            return false;
        }
        if (other.isEnableSsl() != null && !other.isEnableSsl().equals(this.isEnableSsl())) {
            return false;
        }
        if (other.getSslConfiguration() == null ^ this.getSslConfiguration() == null) {
            return false;
        }
        if (other.getSslConfiguration() != null && !other.getSslConfiguration().equals(this.getSslConfiguration())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !((Object)other.getAttributes()).equals(this.getAttributes())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        return other.getCreatedAt() == null || other.getCreatedAt().equals(this.getCreatedAt());
    }
}

