/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.Role;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceProfile
implements Serializable {
    private String path;
    private String instanceProfileName;
    private String instanceProfileId;
    private String arn;
    private Date createDate;
    private ListWithAutoConstructFlag<Role> roles;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public InstanceProfile withPath(String path) {
        this.path = path;
        return this;
    }

    public String getInstanceProfileName() {
        return this.instanceProfileName;
    }

    public void setInstanceProfileName(String instanceProfileName) {
        this.instanceProfileName = instanceProfileName;
    }

    public InstanceProfile withInstanceProfileName(String instanceProfileName) {
        this.instanceProfileName = instanceProfileName;
        return this;
    }

    public String getInstanceProfileId() {
        return this.instanceProfileId;
    }

    public void setInstanceProfileId(String instanceProfileId) {
        this.instanceProfileId = instanceProfileId;
    }

    public InstanceProfile withInstanceProfileId(String instanceProfileId) {
        this.instanceProfileId = instanceProfileId;
        return this;
    }

    public String getArn() {
        return this.arn;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public InstanceProfile withArn(String arn) {
        this.arn = arn;
        return this;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public InstanceProfile withCreateDate(Date createDate) {
        this.createDate = createDate;
        return this;
    }

    public List<Role> getRoles() {
        if (this.roles == null) {
            this.roles = new ListWithAutoConstructFlag();
            this.roles.setAutoConstruct(true);
        }
        return this.roles;
    }

    public void setRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
            return;
        }
        ListWithAutoConstructFlag rolesCopy = new ListWithAutoConstructFlag(roles.size());
        rolesCopy.addAll(roles);
        this.roles = rolesCopy;
    }

    public InstanceProfile withRoles(Role ... roles) {
        if (this.getRoles() == null) {
            this.setRoles(new ArrayList<Role>(roles.length));
        }
        for (Role value : roles) {
            this.getRoles().add(value);
        }
        return this;
    }

    public InstanceProfile withRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
        } else {
            ListWithAutoConstructFlag rolesCopy = new ListWithAutoConstructFlag(roles.size());
            rolesCopy.addAll(roles);
            this.roles = rolesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: " + this.getPath() + ",");
        }
        if (this.getInstanceProfileName() != null) {
            sb.append("InstanceProfileName: " + this.getInstanceProfileName() + ",");
        }
        if (this.getInstanceProfileId() != null) {
            sb.append("InstanceProfileId: " + this.getInstanceProfileId() + ",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: " + this.getArn() + ",");
        }
        if (this.getCreateDate() != null) {
            sb.append("CreateDate: " + this.getCreateDate() + ",");
        }
        if (this.getRoles() != null) {
            sb.append("Roles: " + this.getRoles());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileName() == null ? 0 : this.getInstanceProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceProfileId() == null ? 0 : this.getInstanceProfileId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreateDate() == null ? 0 : this.getCreateDate().hashCode());
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : ((Object)this.getRoles()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProfile)) {
            return false;
        }
        InstanceProfile other = (InstanceProfile)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getInstanceProfileName() == null ^ this.getInstanceProfileName() == null) {
            return false;
        }
        if (other.getInstanceProfileName() != null && !other.getInstanceProfileName().equals(this.getInstanceProfileName())) {
            return false;
        }
        if (other.getInstanceProfileId() == null ^ this.getInstanceProfileId() == null) {
            return false;
        }
        if (other.getInstanceProfileId() != null && !other.getInstanceProfileId().equals(this.getInstanceProfileId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreateDate() == null ^ this.getCreateDate() == null) {
            return false;
        }
        if (other.getCreateDate() != null && !other.getCreateDate().equals(this.getCreateDate())) {
            return false;
        }
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        return other.getRoles() == null || ((Object)other.getRoles()).equals(this.getRoles());
    }
}

