/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableRequestMarshaller
implements Marshaller<Request<CreateTableRequest>, CreateTableRequest> {
    @Override
    public Request<CreateTableRequest> marshall(CreateTableRequest createTableRequest) {
        if (createTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTableRequest> request = new DefaultRequest<CreateTableRequest>(createTableRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.CreateTable";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            ProvisionedThroughput provisionedThroughput;
            List<LocalSecondaryIndex> localSecondaryIndexesList;
            List<KeySchemaElement> keySchemaList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<AttributeDefinition> attributeDefinitionsList = createTableRequest.getAttributeDefinitions();
            if (attributeDefinitionsList != null) {
                jsonWriter.key("AttributeDefinitions");
                jsonWriter.array();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    jsonWriter.object();
                    if (attributeDefinitionsListValue.getAttributeName() != null) {
                        jsonWriter.key("AttributeName").value(attributeDefinitionsListValue.getAttributeName());
                    }
                    if (attributeDefinitionsListValue.getAttributeType() != null) {
                        jsonWriter.key("AttributeType").value(attributeDefinitionsListValue.getAttributeType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createTableRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(createTableRequest.getTableName());
            }
            if ((keySchemaList = createTableRequest.getKeySchema()) != null) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    jsonWriter.object();
                    if (keySchemaListValue.getAttributeName() != null) {
                        jsonWriter.key("AttributeName").value(keySchemaListValue.getAttributeName());
                    }
                    if (keySchemaListValue.getKeyType() != null) {
                        jsonWriter.key("KeyType").value(keySchemaListValue.getKeyType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if ((localSecondaryIndexesList = createTableRequest.getLocalSecondaryIndexes()) != null) {
                jsonWriter.key("LocalSecondaryIndexes");
                jsonWriter.array();
                for (LocalSecondaryIndex localSecondaryIndexesListValue : localSecondaryIndexesList) {
                    Projection projection;
                    List<KeySchemaElement> List2;
                    if (localSecondaryIndexesListValue == null) continue;
                    jsonWriter.object();
                    if (localSecondaryIndexesListValue.getIndexName() != null) {
                        jsonWriter.key("IndexName").value(localSecondaryIndexesListValue.getIndexName());
                    }
                    if ((List2 = localSecondaryIndexesListValue.getKeySchema()) != null) {
                        jsonWriter.key("KeySchema");
                        jsonWriter.array();
                        for (KeySchemaElement ListValue : List2) {
                            if (ListValue == null) continue;
                            jsonWriter.object();
                            if (ListValue.getAttributeName() != null) {
                                jsonWriter.key("AttributeName").value(ListValue.getAttributeName());
                            }
                            if (ListValue.getKeyType() != null) {
                                jsonWriter.key("KeyType").value(ListValue.getKeyType());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    if ((projection = localSecondaryIndexesListValue.getProjection()) != null) {
                        List<String> nonKeyAttributesList;
                        jsonWriter.key("Projection");
                        jsonWriter.object();
                        if (projection.getProjectionType() != null) {
                            jsonWriter.key("ProjectionType").value(projection.getProjectionType());
                        }
                        if ((nonKeyAttributesList = projection.getNonKeyAttributes()) != null) {
                            jsonWriter.key("NonKeyAttributes");
                            jsonWriter.array();
                            for (String nonKeyAttributesListValue : nonKeyAttributesList) {
                                if (nonKeyAttributesListValue == null) continue;
                                jsonWriter.value(nonKeyAttributesListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if ((provisionedThroughput = createTableRequest.getProvisionedThroughput()) != null) {
                jsonWriter.key("ProvisionedThroughput");
                jsonWriter.object();
                if (provisionedThroughput.getReadCapacityUnits() != null) {
                    jsonWriter.key("ReadCapacityUnits").value(provisionedThroughput.getReadCapacityUnits());
                }
                if (provisionedThroughput.getWriteCapacityUnits() != null) {
                    jsonWriter.key("WriteCapacityUnits").value(provisionedThroughput.getWriteCapacityUnits());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

