/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.JsonDataConverter;
import com.amazonaws.services.simpleworkflow.flow.StartWorkflowOptions;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClientFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkflowClientFactoryBase<T>
implements WorkflowClientFactory<T> {
    private GenericWorkflowClient genericClient;
    private DataConverter dataConverter;
    private StartWorkflowOptions startWorkflowOptions = new StartWorkflowOptions();
    private final DecisionContextProvider decisionContextProvider = new DecisionContextProviderImpl();

    public WorkflowClientFactoryBase() {
        this(null, null, null);
    }

    public WorkflowClientFactoryBase(StartWorkflowOptions startWorkflowOptions) {
        this(startWorkflowOptions, null, null);
    }

    public WorkflowClientFactoryBase(StartWorkflowOptions startWorkflowOptions, DataConverter dataConverter) {
        this(startWorkflowOptions, dataConverter, null);
    }

    public WorkflowClientFactoryBase(StartWorkflowOptions startWorkflowOptions, DataConverter dataConverter, GenericWorkflowClient genericClient) {
        this.startWorkflowOptions = startWorkflowOptions;
        this.dataConverter = dataConverter == null ? new JsonDataConverter() : dataConverter;
        this.genericClient = genericClient;
    }

    @Override
    public GenericWorkflowClient getGenericClient() {
        return this.genericClient;
    }

    @Override
    public void setGenericClient(GenericWorkflowClient genericClient) {
        this.genericClient = genericClient;
    }

    @Override
    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    @Override
    public void setDataConverter(DataConverter dataConverter) {
        this.dataConverter = dataConverter;
    }

    @Override
    public StartWorkflowOptions getStartWorkflowOptions() {
        return this.startWorkflowOptions;
    }

    @Override
    public void setStartWorkflowOptions(StartWorkflowOptions startWorkflowOptions) {
        this.startWorkflowOptions = startWorkflowOptions;
    }

    @Override
    public T getClient() {
        GenericWorkflowClient client = this.getGenericClientToUse();
        String workflowId = client.generateUniqueId();
        WorkflowExecution execution = new WorkflowExecution().withWorkflowId(workflowId);
        return this.getClient(execution, this.startWorkflowOptions, this.dataConverter);
    }

    @Override
    public T getClient(String workflowId) {
        if (workflowId == null || workflowId.isEmpty()) {
            throw new IllegalArgumentException("workflowId");
        }
        WorkflowExecution execution = new WorkflowExecution().withWorkflowId(workflowId);
        return this.getClient(execution, this.startWorkflowOptions, this.dataConverter);
    }

    @Override
    public T getClient(WorkflowExecution execution) {
        return this.getClient(execution, this.startWorkflowOptions, this.dataConverter);
    }

    @Override
    public T getClient(WorkflowExecution execution, StartWorkflowOptions options) {
        return this.getClient(execution, options, this.dataConverter);
    }

    @Override
    public T getClient(WorkflowExecution execution, StartWorkflowOptions options, DataConverter dataConverter) {
        GenericWorkflowClient client = this.getGenericClientToUse();
        return this.createClientInstance(execution, options, dataConverter, client);
    }

    private GenericWorkflowClient getGenericClientToUse() {
        GenericWorkflowClient result = this.genericClient == null ? this.decisionContextProvider.getDecisionContext().getWorkflowClient() : this.genericClient;
        return result;
    }

    protected abstract T createClientInstance(WorkflowExecution var1, StartWorkflowOptions var2, DataConverter var3, GenericWorkflowClient var4);
}

