/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegationSet
implements Serializable {
    private List<String> nameServers;

    public DelegationSet() {
    }

    public DelegationSet(List<String> nameServers) {
        this.nameServers = nameServers;
    }

    public List<String> getNameServers() {
        if (this.nameServers == null) {
            this.nameServers = new ArrayList<String>();
        }
        return this.nameServers;
    }

    public void setNameServers(Collection<String> nameServers) {
        if (nameServers == null) {
            this.nameServers = null;
            return;
        }
        ArrayList<String> nameServersCopy = new ArrayList<String>(nameServers.size());
        nameServersCopy.addAll(nameServers);
        this.nameServers = nameServersCopy;
    }

    public DelegationSet withNameServers(String ... nameServers) {
        if (this.getNameServers() == null) {
            this.setNameServers(new ArrayList<String>(nameServers.length));
        }
        for (String value : nameServers) {
            this.getNameServers().add(value);
        }
        return this;
    }

    public DelegationSet withNameServers(Collection<String> nameServers) {
        if (nameServers == null) {
            this.nameServers = null;
        } else {
            ArrayList<String> nameServersCopy = new ArrayList<String>(nameServers.size());
            nameServersCopy.addAll(nameServers);
            this.nameServers = nameServersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNameServers() != null) {
            sb.append("NameServers: " + this.getNameServers());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNameServers() == null ? 0 : ((Object)this.getNameServers()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationSet)) {
            return false;
        }
        DelegationSet other = (DelegationSet)obj;
        if (other.getNameServers() == null ^ this.getNameServers() == null) {
            return false;
        }
        return other.getNameServers() == null || ((Object)other.getNameServers()).equals(this.getNameServers());
    }
}

