/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.SnapshotState;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snapshot
implements Serializable {
    private String snapshotId;
    private String volumeId;
    private String state;
    private Date startTime;
    private String progress;
    private String ownerId;
    private String description;
    private Integer volumeSize;
    private String ownerAlias;
    private List<Tag> tags;

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Snapshot withSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        return this;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    public Snapshot withVolumeId(String volumeId) {
        this.volumeId = volumeId;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Snapshot withState(String state) {
        this.state = state;
        return this;
    }

    public void setState(SnapshotState state) {
        this.state = state.toString();
    }

    public Snapshot withState(SnapshotState state) {
        this.state = state.toString();
        return this;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Snapshot withStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public Snapshot withProgress(String progress) {
        this.progress = progress;
        return this;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Snapshot withOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Snapshot withDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer getVolumeSize() {
        return this.volumeSize;
    }

    public void setVolumeSize(Integer volumeSize) {
        this.volumeSize = volumeSize;
    }

    public Snapshot withVolumeSize(Integer volumeSize) {
        this.volumeSize = volumeSize;
        return this;
    }

    public String getOwnerAlias() {
        return this.ownerAlias;
    }

    public void setOwnerAlias(String ownerAlias) {
        this.ownerAlias = ownerAlias;
    }

    public Snapshot withOwnerAlias(String ownerAlias) {
        this.ownerAlias = ownerAlias;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Snapshot withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Snapshot withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSnapshotId() != null) {
            sb.append("SnapshotId: " + this.getSnapshotId() + ", ");
        }
        if (this.getVolumeId() != null) {
            sb.append("VolumeId: " + this.getVolumeId() + ", ");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ", ");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: " + this.getStartTime() + ", ");
        }
        if (this.getProgress() != null) {
            sb.append("Progress: " + this.getProgress() + ", ");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: " + this.getOwnerId() + ", ");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ", ");
        }
        if (this.getVolumeSize() != null) {
            sb.append("VolumeSize: " + this.getVolumeSize() + ", ");
        }
        if (this.getOwnerAlias() != null) {
            sb.append("OwnerAlias: " + this.getOwnerAlias() + ", ");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSnapshotId() == null ? 0 : this.getSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeId() == null ? 0 : this.getVolumeId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getProgress() == null ? 0 : this.getProgress().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeSize() == null ? 0 : this.getVolumeSize().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerAlias() == null ? 0 : this.getOwnerAlias().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        if (other.getSnapshotId() == null ^ this.getSnapshotId() == null) {
            return false;
        }
        if (other.getSnapshotId() != null && !other.getSnapshotId().equals(this.getSnapshotId())) {
            return false;
        }
        if (other.getVolumeId() == null ^ this.getVolumeId() == null) {
            return false;
        }
        if (other.getVolumeId() != null && !other.getVolumeId().equals(this.getVolumeId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getProgress() == null ^ this.getProgress() == null) {
            return false;
        }
        if (other.getProgress() != null && !other.getProgress().equals(this.getProgress())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVolumeSize() == null ^ this.getVolumeSize() == null) {
            return false;
        }
        if (other.getVolumeSize() != null && !other.getVolumeSize().equals(this.getVolumeSize())) {
            return false;
        }
        if (other.getOwnerAlias() == null ^ this.getOwnerAlias() == null) {
            return false;
        }
        if (other.getOwnerAlias() != null && !other.getOwnerAlias().equals(this.getOwnerAlias())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

