/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeRegionsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private List<String> regionNames;
    private List<Filter> filters;

    public List<String> getRegionNames() {
        if (this.regionNames == null) {
            this.regionNames = new ArrayList<String>();
        }
        return this.regionNames;
    }

    public void setRegionNames(Collection<String> regionNames) {
        if (regionNames == null) {
            this.regionNames = null;
            return;
        }
        ArrayList<String> regionNamesCopy = new ArrayList<String>(regionNames.size());
        regionNamesCopy.addAll(regionNames);
        this.regionNames = regionNamesCopy;
    }

    public DescribeRegionsRequest withRegionNames(String ... regionNames) {
        if (this.getRegionNames() == null) {
            this.setRegionNames(new ArrayList<String>(regionNames.length));
        }
        for (String value : regionNames) {
            this.getRegionNames().add(value);
        }
        return this;
    }

    public DescribeRegionsRequest withRegionNames(Collection<String> regionNames) {
        if (regionNames == null) {
            this.regionNames = null;
        } else {
            ArrayList<String> regionNamesCopy = new ArrayList<String>(regionNames.size());
            regionNamesCopy.addAll(regionNames);
            this.regionNames = regionNamesCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ArrayList<Filter> filtersCopy = new ArrayList<Filter>(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeRegionsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeRegionsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ArrayList<Filter> filtersCopy = new ArrayList<Filter>(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegionNames() != null) {
            sb.append("RegionNames: " + this.getRegionNames() + ", ");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegionNames() == null ? 0 : ((Object)this.getRegionNames()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRegionsRequest)) {
            return false;
        }
        DescribeRegionsRequest other = (DescribeRegionsRequest)obj;
        if (other.getRegionNames() == null ^ this.getRegionNames() == null) {
            return false;
        }
        if (other.getRegionNames() != null && !((Object)other.getRegionNames()).equals(this.getRegionNames())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || ((Object)other.getFilters()).equals(this.getFilters());
    }
}

