/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyNetworkInterfaceAttributeRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String networkInterfaceId;
    private String description;
    private Boolean sourceDestCheck;
    private List<String> groups;
    private NetworkInterfaceAttachmentChanges attachment;

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public ModifyNetworkInterfaceAttributeRequest withNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ModifyNetworkInterfaceAttributeRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public ModifyNetworkInterfaceAttributeRequest withSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
        return this;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ArrayList<String> groupsCopy = new ArrayList<String>(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public ModifyNetworkInterfaceAttributeRequest withGroups(String ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public ModifyNetworkInterfaceAttributeRequest withGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ArrayList<String> groupsCopy = new ArrayList<String>(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public NetworkInterfaceAttachmentChanges getAttachment() {
        return this.attachment;
    }

    public void setAttachment(NetworkInterfaceAttachmentChanges attachment) {
        this.attachment = attachment;
    }

    public ModifyNetworkInterfaceAttributeRequest withAttachment(NetworkInterfaceAttachmentChanges attachment) {
        this.attachment = attachment;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: " + this.getNetworkInterfaceId() + ", ");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ", ");
        }
        if (this.isSourceDestCheck() != null) {
            sb.append("SourceDestCheck: " + this.isSourceDestCheck() + ", ");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: " + this.getGroups() + ", ");
        }
        if (this.getAttachment() != null) {
            sb.append("Attachment: " + this.getAttachment() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.isSourceDestCheck() == null ? 0 : this.isSourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : ((Object)this.getGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getAttachment() == null ? 0 : this.getAttachment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ModifyNetworkInterfaceAttributeRequest other = (ModifyNetworkInterfaceAttributeRequest)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.isSourceDestCheck() == null ^ this.isSourceDestCheck() == null) {
            return false;
        }
        if (other.isSourceDestCheck() != null && !other.isSourceDestCheck().equals(this.isSourceDestCheck())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !((Object)other.getGroups()).equals(this.getGroups())) {
            return false;
        }
        if (other.getAttachment() == null ^ this.getAttachment() == null) {
            return false;
        }
        return other.getAttachment() == null || other.getAttachment().equals(this.getAttachment());
    }
}

