/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryCallable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryInterceptorBase;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicy;
import java.util.Date;
import java.util.concurrent.CancellationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryInterceptorWithResult
extends RetryInterceptorBase {
    public RetryInterceptorWithResult(RetryCallable retryCallable, RetryPolicy retryPolicy) {
        super(retryCallable, retryPolicy);
    }

    @Override
    public Object execute() throws Throwable {
        Settable<Object> result = new Settable<Object>();
        WorkflowClock clock = this.contextProvider.getDecisionContext().getWorkflowClock();
        this.scheduleWithRetry(result, null, 1, clock.currentTimeMillis(), 0L, clock);
        return result;
    }

    private void scheduleWithRetry(final Settable<Object> result, Throwable failure, final int attempt, final long firstAttemptTime, long timeOfRecordedFailure, final WorkflowClock clock) throws Throwable {
        long delay = -1L;
        if (attempt > 1) {
            if (!this.retryPolicy.isRetryable(failure)) {
                throw failure;
            }
            delay = this.retryPolicy.nextRetryDelaySeconds(new Date(firstAttemptTime), new Date(timeOfRecordedFailure), attempt);
            if (delay < 0L) {
                throw failure;
            }
        }
        if (delay > 0L) {
            Promise<Void> timer = clock.createTimer(delay);
            new Task(new Promise[]{timer}){

                protected void doExecute() throws Throwable {
                    RetryInterceptorWithResult.this.invoke(result, attempt, firstAttemptTime, clock);
                }
            };
        } else {
            this.invoke(result, attempt, firstAttemptTime, clock);
        }
    }

    private void invoke(final Settable<Object> result, final int attempt, final long firstAttemptTime, final WorkflowClock clock) {
        final Settable shouldRetry = new Settable();
        new TryCatchFinally(){
            Throwable failureToRetry = null;

            protected void doTry() throws Throwable {
                result.chain(RetryInterceptorWithResult.this.retryCallable.call());
            }

            protected void doCatch(Throwable failure) throws Throwable {
                if (failure instanceof Error || failure instanceof CancellationException) {
                    throw failure;
                }
                if (result.isReady()) {
                    throw new IllegalStateException("Cannot retry as result is in ready state", failure);
                }
                result.unchain();
                this.failureToRetry = failure;
            }

            protected void doFinally() throws Throwable {
                shouldRetry.set(this.failureToRetry);
            }
        };
        new Task(new Promise[]{shouldRetry}){

            protected void doExecute() throws Throwable {
                Throwable failure = (Throwable)shouldRetry.get();
                if (failure != null) {
                    RetryInterceptorWithResult.this.scheduleWithRetry(result, (Exception)failure, attempt + 1, firstAttemptTime, clock.currentTimeMillis(), clock);
                }
            }
        };
    }
}

