/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.CachingBehavior;
import com.amazonaws.services.cloudfront.model.CreateDistributionRequest;
import com.amazonaws.services.cloudfront.model.CustomOrigin;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.RequiredProtocols;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDistributionRequestMarshaller
implements Marshaller<Request<CreateDistributionRequest>, CreateDistributionRequest> {
    @Override
    public Request<CreateDistributionRequest> marshall(CreateDistributionRequest createDistributionRequest) {
        DistributionConfig distributionConfigDistributionConfig;
        if (createDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDistributionRequest> request = new DefaultRequest<CreateDistributionRequest>(createDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2012-03-15/distribution";
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[ &]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2012-03-15/");
        if (createDistributionRequest != null && (distributionConfigDistributionConfig = createDistributionRequest.getDistributionConfig()) != null) {
            CachingBehavior cachingBehaviorCachingBehavior;
            RequiredProtocols requiredProtocolsRequiredProtocols;
            TrustedSigners trustedSignersTrustedSigners;
            LoggingConfig loggingConfigLogging;
            List<String> cNAMEList;
            CustomOrigin customOriginCustomOrigin;
            S3Origin s3OriginS3Origin;
            xmlWriter.startElement("DistributionConfig");
            if (distributionConfigDistributionConfig != null && (s3OriginS3Origin = distributionConfigDistributionConfig.getS3Origin()) != null) {
                xmlWriter.startElement("S3Origin");
                if (s3OriginS3Origin.getDNSName() != null) {
                    xmlWriter.startElement("DNSName").value(s3OriginS3Origin.getDNSName()).endElement();
                }
                if (s3OriginS3Origin.getOriginAccessIdentity() != null) {
                    xmlWriter.startElement("OriginAccessIdentity").value(s3OriginS3Origin.getOriginAccessIdentity()).endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (customOriginCustomOrigin = distributionConfigDistributionConfig.getCustomOrigin()) != null) {
                xmlWriter.startElement("CustomOrigin");
                if (customOriginCustomOrigin.getDNSName() != null) {
                    xmlWriter.startElement("DNSName").value(customOriginCustomOrigin.getDNSName()).endElement();
                }
                if (customOriginCustomOrigin.getHTTPPort() != null) {
                    xmlWriter.startElement("HTTPPort").value(customOriginCustomOrigin.getHTTPPort()).endElement();
                }
                if (customOriginCustomOrigin.getHTTPSPort() != null) {
                    xmlWriter.startElement("HTTPSPort").value(customOriginCustomOrigin.getHTTPSPort()).endElement();
                }
                if (customOriginCustomOrigin.getOriginProtocolPolicy() != null) {
                    xmlWriter.startElement("OriginProtocolPolicy").value(customOriginCustomOrigin.getOriginProtocolPolicy()).endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(distributionConfigDistributionConfig.getCallerReference()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (cNAMEList = distributionConfigDistributionConfig.getCNAME()) != null && cNAMEList.size() > 0) {
                int cNAMEListIndex = 1;
                for (String cNAMEListValue : cNAMEList) {
                    xmlWriter.startElement("CNAME");
                    xmlWriter.value(cNAMEListValue);
                    xmlWriter.endElement();
                    ++cNAMEListIndex;
                }
            }
            if (distributionConfigDistributionConfig.getComment() != null) {
                xmlWriter.startElement("Comment").value(distributionConfigDistributionConfig.getComment()).endElement();
            }
            if (distributionConfigDistributionConfig.isEnabled() != null) {
                xmlWriter.startElement("Enabled").value(distributionConfigDistributionConfig.isEnabled()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (loggingConfigLogging = distributionConfigDistributionConfig.getLogging()) != null) {
                xmlWriter.startElement("Logging");
                if (loggingConfigLogging.getBucket() != null) {
                    xmlWriter.startElement("Bucket").value(loggingConfigLogging.getBucket()).endElement();
                }
                if (loggingConfigLogging.getPrefix() != null) {
                    xmlWriter.startElement("Prefix").value(loggingConfigLogging.getPrefix()).endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (trustedSignersTrustedSigners = distributionConfigDistributionConfig.getTrustedSigners()) != null) {
                List<String> awsAccountNumbersList;
                xmlWriter.startElement("TrustedSigners");
                if (trustedSignersTrustedSigners.getSelf() != null) {
                    xmlWriter.startElement("Self").value(trustedSignersTrustedSigners.getSelf()).endElement();
                }
                if (trustedSignersTrustedSigners != null && (awsAccountNumbersList = trustedSignersTrustedSigners.getAwsAccountNumbers()) != null && awsAccountNumbersList.size() > 0) {
                    int awsAccountNumbersListIndex = 1;
                    for (String awsAccountNumbersListValue : awsAccountNumbersList) {
                        xmlWriter.startElement("AwsAccountNumber");
                        xmlWriter.value(awsAccountNumbersListValue);
                        xmlWriter.endElement();
                        ++awsAccountNumbersListIndex;
                    }
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (requiredProtocolsRequiredProtocols = distributionConfigDistributionConfig.getRequiredProtocols()) != null) {
                List<String> protocolsList;
                xmlWriter.startElement("RequiredProtocols");
                if (requiredProtocolsRequiredProtocols != null && (protocolsList = requiredProtocolsRequiredProtocols.getProtocols()) != null && protocolsList.size() > 0) {
                    int protocolsListIndex = 1;
                    for (String protocolsListValue : protocolsList) {
                        xmlWriter.startElement("Protocol");
                        xmlWriter.value(protocolsListValue);
                        xmlWriter.endElement();
                        ++protocolsListIndex;
                    }
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.getDefaultRootObject() != null) {
                xmlWriter.startElement("DefaultRootObject").value(distributionConfigDistributionConfig.getDefaultRootObject()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (cachingBehaviorCachingBehavior = distributionConfigDistributionConfig.getCachingBehavior()) != null) {
                xmlWriter.startElement("CachingBehavior");
                if (cachingBehaviorCachingBehavior.getMinTTL() != null) {
                    xmlWriter.startElement("MinTTL").value(cachingBehaviorCachingBehavior.getMinTTL()).endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes().length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

