/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.aspectj;

import com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetry;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.interceptors.ExponentialRetryPolicy;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryCallable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryInterceptorBase;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryInterceptorVoid;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryInterceptorWithResult;
import java.util.Arrays;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class ExponentialRetryAspect {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ExponentialRetryAspect ajc$perSingletonInstance;

    @Around(value="execution(@com.amazonaws.services.simpleworkflow.flow.annotations.ExponentialRetry * *(..)) && @annotation(retryAnnotation)")
    public Object retry(final ProceedingJoinPoint pjp, ExponentialRetry retryAnnotation) throws Throwable {
        ExponentialRetryPolicy retryPolicy = this.createExponentialRetryPolicy(retryAnnotation);
        RetryCallable retryCallable = new RetryCallable(){

            public Promise call() throws Throwable {
                return (Promise)pjp.proceed();
            }
        };
        boolean isVoidReturnType = false;
        Signature signature = pjp.getStaticPart().getSignature();
        if (signature instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)signature;
            isVoidReturnType = methodSignature != null ? Void.TYPE.equals(methodSignature.getReturnType()) : false;
        }
        RetryInterceptorBase interceptor = null;
        interceptor = isVoidReturnType ? new RetryInterceptorVoid(retryCallable, retryPolicy) : new RetryInterceptorWithResult(retryCallable, retryPolicy);
        return interceptor.execute();
    }

    private ExponentialRetryPolicy createExponentialRetryPolicy(ExponentialRetry retryAnnotation) {
        ExponentialRetryPolicy retryPolicy = ((ExponentialRetryPolicy)((ExponentialRetryPolicy)new ExponentialRetryPolicy(retryAnnotation.initialRetryIntervalSeconds()).withExceptionsToRetry(Arrays.asList(retryAnnotation.exceptionsToRetry()))).withExceptionsToExclude(Arrays.asList(retryAnnotation.excludeExceptions()))).withBackoffCoefficient(retryAnnotation.backoffCoefficient()).withMaximumRetryIntervalSeconds(retryAnnotation.maximumRetryIntervalSeconds()).withRetryExpirationIntervalSeconds(retryAnnotation.retryExpirationSeconds()).withMaximumAttempts(retryAnnotation.maximumAttempts());
        retryPolicy.validate();
        return retryPolicy;
    }

    public static ExponentialRetryAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.amazonaws.services.simpleworkflow.flow.aspectj.ExponentialRetryAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            ExponentialRetryAspect.ajc$perSingletonInstance = new ExponentialRetryAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

