/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeActivityTypeRequestMarshaller
implements Marshaller<Request<DescribeActivityTypeRequest>, DescribeActivityTypeRequest> {
    @Override
    public Request<DescribeActivityTypeRequest> marshall(DescribeActivityTypeRequest describeActivityTypeRequest) {
        if (describeActivityTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeActivityTypeRequest> request = new DefaultRequest<DescribeActivityTypeRequest>(describeActivityTypeRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.DescribeActivityType";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            ActivityType activityTypeActivityType;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeActivityTypeRequest.getDomain() != null) {
                jsonWriter.key("domain").value(describeActivityTypeRequest.getDomain());
            }
            if (describeActivityTypeRequest != null && (activityTypeActivityType = describeActivityTypeRequest.getActivityType()) != null) {
                jsonWriter.key("activityType").object();
                if (activityTypeActivityType.getName() != null) {
                    jsonWriter.key("name").value(activityTypeActivityType.getName());
                }
                if (activityTypeActivityType.getVersion() != null) {
                    jsonWriter.key("version").value(activityTypeActivityType.getVersion());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

