/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.services.s3.internal.Constants;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtils {
    private static final Log log = LogFactory.getLog(ServiceUtils.class);
    protected static final DateUtils dateUtils = new DateUtils();

    public static Date parseIso8601Date(String dateString) throws ParseException {
        return dateUtils.parseIso8601Date(dateString);
    }

    public static String formatIso8601Date(Date date) {
        return dateUtils.formatIso8601Date(date);
    }

    public static Date parseRfc822Date(String dateString) throws ParseException {
        return dateUtils.parseRfc822Date(dateString);
    }

    public static String formatRfc822Date(Date date) {
        return dateUtils.formatRfc822Date(date);
    }

    public static boolean isMultipartUploadETag(String eTag) {
        return eTag.contains("-");
    }

    public static byte[] toByteArray(String s) {
        try {
            return s.getBytes(Constants.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)("Encoding " + Constants.DEFAULT_ENCODING + " is not supported"), (Throwable)e);
            return s.getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {
                System.err.println("Unable to close input stream of hash candidate: " + e);
            }
        }
    }

    public static byte[] computeMD5Hash(byte[] data) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.computeMD5Hash(new ByteArrayInputStream(data));
    }

    public static String removeQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        try {
            String encodedString = URLEncoder.encode(s, Constants.DEFAULT_ENCODING);
            return encodedString.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to encode path: " + s, e);
        }
    }

    public static URL convertRequestToUrl(Request<?> request) {
        String urlString = request.getEndpoint() + "/" + request.getResourcePath();
        boolean firstParam = true;
        for (String param : request.getParameters().keySet()) {
            if (firstParam) {
                urlString = urlString + "?";
                firstParam = false;
            } else {
                urlString = urlString + "&";
            }
            String value = request.getParameters().get(param);
            urlString = urlString + param + "=" + ServiceUtils.urlEncode(value);
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new AmazonClientException("Unable to convert request to well formed URL: " + e.getMessage(), e);
        }
    }

    public static String join(List<String> strings) {
        String result = "";
        boolean first = true;
        for (String s : strings) {
            if (!first) {
                result = result + ", ";
            }
            result = result + s;
            first = false;
        }
        return result;
    }

    public static void downloadObjectToFile(S3Object s3Object, File destinationFile) {
        OutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = s3Object.getObjectContent().read(buffer)) > -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to store object contents to disk: " + e.getMessage(), e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception e) {}
            try {
                s3Object.getObjectContent().close();
            }
            catch (Exception e) {}
        }
        try {
            byte[] serverSideHash;
            byte[] clientSideHash;
            if (!ServiceUtils.isMultipartUploadETag(s3Object.getObjectMetadata().getETag()) && !Arrays.equals(clientSideHash = ServiceUtils.computeMD5Hash(new FileInputStream(destinationFile)), serverSideHash = BinaryUtils.fromHex(s3Object.getObjectMetadata().getETag()))) {
                throw new AmazonClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Amazon S3.  The data stored in '" + destinationFile.getAbsolutePath() + "' may be corrupt.");
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to calculate MD5 hash to validate download: " + e.getMessage()), (Throwable)e);
        }
    }
}

