/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.PropagatedRoute;
import com.amazonaws.services.ec2.model.PropagatingVgw;
import com.amazonaws.services.ec2.model.Route;
import com.amazonaws.services.ec2.model.RouteTableAssociation;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteTable {
    private String routeTableId;
    private String vpcId;
    private List<Route> routes;
    private List<RouteTableAssociation> associations;
    private List<Tag> tags;
    private List<PropagatingVgw> propagatingVgws;
    private List<PropagatedRoute> propagatedRoutes;

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public void setRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
    }

    public RouteTable withRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public RouteTable withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        return this.routes;
    }

    public void setRoutes(Collection<Route> routes) {
        if (routes == null) {
            this.routes = null;
            return;
        }
        ArrayList<Route> routesCopy = new ArrayList<Route>(routes.size());
        routesCopy.addAll(routes);
        this.routes = routesCopy;
    }

    public RouteTable withRoutes(Route ... routes) {
        if (this.getRoutes() == null) {
            this.setRoutes(new ArrayList<Route>(routes.length));
        }
        for (Route value : routes) {
            this.getRoutes().add(value);
        }
        return this;
    }

    public RouteTable withRoutes(Collection<Route> routes) {
        if (routes == null) {
            this.routes = null;
        } else {
            ArrayList<Route> routesCopy = new ArrayList<Route>(routes.size());
            routesCopy.addAll(routes);
            this.routes = routesCopy;
        }
        return this;
    }

    public List<RouteTableAssociation> getAssociations() {
        if (this.associations == null) {
            this.associations = new ArrayList<RouteTableAssociation>();
        }
        return this.associations;
    }

    public void setAssociations(Collection<RouteTableAssociation> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        ArrayList<RouteTableAssociation> associationsCopy = new ArrayList<RouteTableAssociation>(associations.size());
        associationsCopy.addAll(associations);
        this.associations = associationsCopy;
    }

    public RouteTable withAssociations(RouteTableAssociation ... associations) {
        if (this.getAssociations() == null) {
            this.setAssociations(new ArrayList<RouteTableAssociation>(associations.length));
        }
        for (RouteTableAssociation value : associations) {
            this.getAssociations().add(value);
        }
        return this;
    }

    public RouteTable withAssociations(Collection<RouteTableAssociation> associations) {
        if (associations == null) {
            this.associations = null;
        } else {
            ArrayList<RouteTableAssociation> associationsCopy = new ArrayList<RouteTableAssociation>(associations.size());
            associationsCopy.addAll(associations);
            this.associations = associationsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RouteTable withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RouteTable withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public List<PropagatingVgw> getPropagatingVgws() {
        if (this.propagatingVgws == null) {
            this.propagatingVgws = new ArrayList<PropagatingVgw>();
        }
        return this.propagatingVgws;
    }

    public void setPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
        if (propagatingVgws == null) {
            this.propagatingVgws = null;
            return;
        }
        ArrayList<PropagatingVgw> propagatingVgwsCopy = new ArrayList<PropagatingVgw>(propagatingVgws.size());
        propagatingVgwsCopy.addAll(propagatingVgws);
        this.propagatingVgws = propagatingVgwsCopy;
    }

    public RouteTable withPropagatingVgws(PropagatingVgw ... propagatingVgws) {
        if (this.getPropagatingVgws() == null) {
            this.setPropagatingVgws(new ArrayList<PropagatingVgw>(propagatingVgws.length));
        }
        for (PropagatingVgw value : propagatingVgws) {
            this.getPropagatingVgws().add(value);
        }
        return this;
    }

    public RouteTable withPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
        if (propagatingVgws == null) {
            this.propagatingVgws = null;
        } else {
            ArrayList<PropagatingVgw> propagatingVgwsCopy = new ArrayList<PropagatingVgw>(propagatingVgws.size());
            propagatingVgwsCopy.addAll(propagatingVgws);
            this.propagatingVgws = propagatingVgwsCopy;
        }
        return this;
    }

    public List<PropagatedRoute> getPropagatedRoutes() {
        if (this.propagatedRoutes == null) {
            this.propagatedRoutes = new ArrayList<PropagatedRoute>();
        }
        return this.propagatedRoutes;
    }

    public void setPropagatedRoutes(Collection<PropagatedRoute> propagatedRoutes) {
        if (propagatedRoutes == null) {
            this.propagatedRoutes = null;
            return;
        }
        ArrayList<PropagatedRoute> propagatedRoutesCopy = new ArrayList<PropagatedRoute>(propagatedRoutes.size());
        propagatedRoutesCopy.addAll(propagatedRoutes);
        this.propagatedRoutes = propagatedRoutesCopy;
    }

    public RouteTable withPropagatedRoutes(PropagatedRoute ... propagatedRoutes) {
        if (this.getPropagatedRoutes() == null) {
            this.setPropagatedRoutes(new ArrayList<PropagatedRoute>(propagatedRoutes.length));
        }
        for (PropagatedRoute value : propagatedRoutes) {
            this.getPropagatedRoutes().add(value);
        }
        return this;
    }

    public RouteTable withPropagatedRoutes(Collection<PropagatedRoute> propagatedRoutes) {
        if (propagatedRoutes == null) {
            this.propagatedRoutes = null;
        } else {
            ArrayList<PropagatedRoute> propagatedRoutesCopy = new ArrayList<PropagatedRoute>(propagatedRoutes.size());
            propagatedRoutesCopy.addAll(propagatedRoutes);
            this.propagatedRoutes = propagatedRoutesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.routeTableId != null) {
            sb.append("RouteTableId: " + this.routeTableId + ", ");
        }
        if (this.vpcId != null) {
            sb.append("VpcId: " + this.vpcId + ", ");
        }
        if (this.routes != null) {
            sb.append("Routes: " + this.routes + ", ");
        }
        if (this.associations != null) {
            sb.append("Associations: " + this.associations + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        if (this.propagatingVgws != null) {
            sb.append("PropagatingVgws: " + this.propagatingVgws + ", ");
        }
        if (this.propagatedRoutes != null) {
            sb.append("PropagatedRoutes: " + this.propagatedRoutes + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRouteTableId() == null ? 0 : this.getRouteTableId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getRoutes() == null ? 0 : ((Object)this.getRoutes()).hashCode());
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : ((Object)this.getAssociations()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        hashCode = 31 * hashCode + (this.getPropagatingVgws() == null ? 0 : ((Object)this.getPropagatingVgws()).hashCode());
        hashCode = 31 * hashCode + (this.getPropagatedRoutes() == null ? 0 : ((Object)this.getPropagatedRoutes()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable)obj;
        if (other.getRouteTableId() == null ^ this.getRouteTableId() == null) {
            return false;
        }
        if (other.getRouteTableId() != null && !other.getRouteTableId().equals(this.getRouteTableId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getRoutes() == null ^ this.getRoutes() == null) {
            return false;
        }
        if (other.getRoutes() != null && !((Object)other.getRoutes()).equals(this.getRoutes())) {
            return false;
        }
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !((Object)other.getAssociations()).equals(this.getAssociations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !((Object)other.getTags()).equals(this.getTags())) {
            return false;
        }
        if (other.getPropagatingVgws() == null ^ this.getPropagatingVgws() == null) {
            return false;
        }
        if (other.getPropagatingVgws() != null && !((Object)other.getPropagatingVgws()).equals(this.getPropagatingVgws())) {
            return false;
        }
        if (other.getPropagatedRoutes() == null ^ this.getPropagatedRoutes() == null) {
            return false;
        }
        return other.getPropagatedRoutes() == null || ((Object)other.getPropagatedRoutes()).equals(this.getPropagatedRoutes());
    }
}

