/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.services.route53.model.ResourceRecordSet;
import com.amazonaws.services.route53.model.transform.AliasTargetStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.ResourceRecordStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRecordSetStaxUnmarshaller
implements Unmarshaller<ResourceRecordSet, StaxUnmarshallerContext> {
    private static ResourceRecordSetStaxUnmarshaller instance;

    @Override
    public ResourceRecordSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResourceRecordSet resourceRecordSet = new ResourceRecordSet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return resourceRecordSet;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    resourceRecordSet.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Type", targetDepth)) {
                    resourceRecordSet.setType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SetIdentifier", targetDepth)) {
                    resourceRecordSet.setSetIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Weight", targetDepth)) {
                    resourceRecordSet.setWeight(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Region", targetDepth)) {
                    resourceRecordSet.setRegion(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TTL", targetDepth)) {
                    resourceRecordSet.setTTL(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceRecords/ResourceRecord", targetDepth)) {
                    resourceRecordSet.getResourceRecords().add(ResourceRecordStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AliasTarget", targetDepth)) continue;
                resourceRecordSet.setAliasTarget(AliasTargetStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return resourceRecordSet;
    }

    public static ResourceRecordSetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceRecordSetStaxUnmarshaller();
        }
        return instance;
    }
}

