/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.datamodeling.internal;

import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodb.datamodeling.internal.PaginatedList;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.services.dynamodb.model.QueryResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedQueryList<T>
extends PaginatedList<T> {
    private final QueryRequest queryRequest;
    private QueryResult queryResult;

    public PaginatedQueryList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, int size, QueryRequest queryRequest, QueryResult queryResult) {
        super(mapper, clazz, dynamo, size);
        this.queryRequest = queryRequest;
        this.queryResult = queryResult;
        this.unmarshallResults(queryResult.getItems());
    }

    @Override
    protected boolean hasMoreResults() {
        return this.queryResult.getLastEvaluatedKey() != null;
    }

    @Override
    protected void loadNextResult() {
        this.queryRequest.setExclusiveStartKey(this.queryResult.getLastEvaluatedKey());
        this.queryResult = this.dynamo.query(PaginatedQueryList.applyUserAgent(this.queryRequest));
        this.unmarshallResults(this.queryResult.getItems());
    }
}

