/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.rds.AmazonRDSAsync;
import com.amazonaws.services.rds.AmazonRDSClient;
import com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.CopyDBSnapshotRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.services.rds.model.CreateDBParameterGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSnapshotRequest;
import com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.CreateOptionGroupRequest;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBParameterGroup;
import com.amazonaws.services.rds.model.DBSecurityGroup;
import com.amazonaws.services.rds.model.DBSnapshot;
import com.amazonaws.services.rds.model.DBSubnetGroup;
import com.amazonaws.services.rds.model.DeleteDBInstanceRequest;
import com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSnapshotRequest;
import com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.DeleteOptionGroupRequest;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsResult;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBParametersRequest;
import com.amazonaws.services.rds.model.DescribeDBParametersResult;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSubnetGroupsResult;
import com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.rds.model.DescribeEventsRequest;
import com.amazonaws.services.rds.model.DescribeEventsResult;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsResult;
import com.amazonaws.services.rds.model.DescribeOptionGroupsRequest;
import com.amazonaws.services.rds.model.DescribeOptionGroupsResult;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesResult;
import com.amazonaws.services.rds.model.EngineDefaults;
import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupResult;
import com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.ModifyOptionGroupRequest;
import com.amazonaws.services.rds.model.OptionGroup;
import com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest;
import com.amazonaws.services.rds.model.RebootDBInstanceRequest;
import com.amazonaws.services.rds.model.ReservedDBInstance;
import com.amazonaws.services.rds.model.ResetDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ResetDBParameterGroupResult;
import com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest;
import com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRDSAsyncClient
extends AmazonRDSClient
implements AmazonRDSAsync {
    private ExecutorService executorService;

    public AmazonRDSAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonRDSAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonRDSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonRDSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DBInstance> createDBInstanceAsync(final CreateDBInstanceRequest createDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBInstance(createDBInstanceRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeEvents(describeEventsRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> restoreDBInstanceToPointInTimeAsync(final RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.restoreDBInstanceToPointInTime(restoreDBInstanceToPointInTimeRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteDBSubnetGroupAsync(final DeleteDBSubnetGroupRequest deleteDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.deleteDBSubnetGroup(deleteDBSubnetGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> createDBSecurityGroupAsync(final CreateDBSecurityGroupRequest createDBSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBSecurityGroup(createDBSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBSubnetGroupsResult> describeDBSubnetGroupsAsync(final DescribeDBSubnetGroupsRequest describeDBSubnetGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSubnetGroupsResult>(){

            @Override
            public DescribeDBSubnetGroupsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBSubnetGroups(describeDBSubnetGroupsRequest);
            }
        });
    }

    @Override
    public Future<DBParameterGroup> createDBParameterGroupAsync(final CreateDBParameterGroupRequest createDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBParameterGroup>(){

            @Override
            public DBParameterGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBParameterGroup(createDBParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ModifyDBParameterGroupResult> modifyDBParameterGroupAsync(final ModifyDBParameterGroupRequest modifyDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyDBParameterGroupResult>(){

            @Override
            public ModifyDBParameterGroupResult call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyDBParameterGroup(modifyDBParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBParameterGroupsResult> describeDBParameterGroupsAsync(final DescribeDBParameterGroupsRequest describeDBParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBParameterGroupsResult>(){

            @Override
            public DescribeDBParameterGroupsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBParameterGroups(describeDBParameterGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBEngineVersionsResult> describeDBEngineVersionsAsync(final DescribeDBEngineVersionsRequest describeDBEngineVersionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBEngineVersionsResult>(){

            @Override
            public DescribeDBEngineVersionsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBEngineVersions(describeDBEngineVersionsRequest);
            }
        });
    }

    @Override
    public Future<ResetDBParameterGroupResult> resetDBParameterGroupAsync(final ResetDBParameterGroupRequest resetDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetDBParameterGroupResult>(){

            @Override
            public ResetDBParameterGroupResult call() throws Exception {
                return AmazonRDSAsyncClient.this.resetDBParameterGroup(resetDBParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<ReservedDBInstance> purchaseReservedDBInstancesOfferingAsync(final PurchaseReservedDBInstancesOfferingRequest purchaseReservedDBInstancesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReservedDBInstance>(){

            @Override
            public ReservedDBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.purchaseReservedDBInstancesOffering(purchaseReservedDBInstancesOfferingRequest);
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> modifyDBSubnetGroupAsync(final ModifyDBSubnetGroupRequest modifyDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyDBSubnetGroup(modifyDBSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> revokeDBSecurityGroupIngressAsync(final RevokeDBSecurityGroupIngressRequest revokeDBSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.revokeDBSecurityGroupIngress(revokeDBSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteOptionGroupAsync(final DeleteOptionGroupRequest deleteOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.deleteOptionGroup(deleteOptionGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DBInstance> rebootDBInstanceAsync(final RebootDBInstanceRequest rebootDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.rebootDBInstance(rebootDBInstanceRequest);
            }
        });
    }

    @Override
    public Future<DBSecurityGroup> authorizeDBSecurityGroupIngressAsync(final AuthorizeDBSecurityGroupIngressRequest authorizeDBSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSecurityGroup>(){

            @Override
            public DBSecurityGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.authorizeDBSecurityGroupIngress(authorizeDBSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                return AmazonRDSAsyncClient.this.describeEngineDefaultParameters(describeEngineDefaultParametersRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> restoreDBInstanceFromDBSnapshotAsync(final RestoreDBInstanceFromDBSnapshotRequest restoreDBInstanceFromDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.restoreDBInstanceFromDBSnapshot(restoreDBInstanceFromDBSnapshotRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteDBSecurityGroupAsync(final DeleteDBSecurityGroupRequest deleteDBSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.deleteDBSecurityGroup(deleteDBSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeOrderableDBInstanceOptionsResult> describeOrderableDBInstanceOptionsAsync(final DescribeOrderableDBInstanceOptionsRequest describeOrderableDBInstanceOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOrderableDBInstanceOptionsResult>(){

            @Override
            public DescribeOrderableDBInstanceOptionsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeOrderableDBInstanceOptions(describeOrderableDBInstanceOptionsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedDBInstancesOfferingsResult> describeReservedDBInstancesOfferingsAsync(final DescribeReservedDBInstancesOfferingsRequest describeReservedDBInstancesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedDBInstancesOfferingsResult>(){

            @Override
            public DescribeReservedDBInstancesOfferingsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeReservedDBInstancesOfferings(describeReservedDBInstancesOfferingsRequest);
            }
        });
    }

    @Override
    public Future<DescribeReservedDBInstancesResult> describeReservedDBInstancesAsync(final DescribeReservedDBInstancesRequest describeReservedDBInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeReservedDBInstancesResult>(){

            @Override
            public DescribeReservedDBInstancesResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeReservedDBInstances(describeReservedDBInstancesRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> deleteDBInstanceAsync(final DeleteDBInstanceRequest deleteDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.deleteDBInstance(deleteDBInstanceRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBSecurityGroupsResult> describeDBSecurityGroupsAsync(final DescribeDBSecurityGroupsRequest describeDBSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSecurityGroupsResult>(){

            @Override
            public DescribeDBSecurityGroupsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBSecurityGroups(describeDBSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DBSnapshot> createDBSnapshotAsync(final CreateDBSnapshotRequest createDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBSnapshot(createDBSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DescribeOptionGroupOptionsResult> describeOptionGroupOptionsAsync(final DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOptionGroupOptionsResult>(){

            @Override
            public DescribeOptionGroupOptionsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeOptionGroupOptions(describeOptionGroupOptionsRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteDBParameterGroupAsync(final DeleteDBParameterGroupRequest deleteDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonRDSAsyncClient.this.deleteDBParameterGroup(deleteDBParameterGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeOptionGroupsResult> describeOptionGroupsAsync(final DescribeOptionGroupsRequest describeOptionGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeOptionGroupsResult>(){

            @Override
            public DescribeOptionGroupsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeOptionGroups(describeOptionGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBInstancesResult> describeDBInstancesAsync(final DescribeDBInstancesRequest describeDBInstancesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBInstancesResult>(){

            @Override
            public DescribeDBInstancesResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBInstances(describeDBInstancesRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBSnapshotsResult> describeDBSnapshotsAsync(final DescribeDBSnapshotsRequest describeDBSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBSnapshotsResult>(){

            @Override
            public DescribeDBSnapshotsResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBSnapshots(describeDBSnapshotsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDBParametersResult> describeDBParametersAsync(final DescribeDBParametersRequest describeDBParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDBParametersResult>(){

            @Override
            public DescribeDBParametersResult call() throws Exception {
                return AmazonRDSAsyncClient.this.describeDBParameters(describeDBParametersRequest);
            }
        });
    }

    @Override
    public Future<DBSnapshot> copyDBSnapshotAsync(final CopyDBSnapshotRequest copyDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                return AmazonRDSAsyncClient.this.copyDBSnapshot(copyDBSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> createDBInstanceReadReplicaAsync(final CreateDBInstanceReadReplicaRequest createDBInstanceReadReplicaRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBInstanceReadReplica(createDBInstanceReadReplicaRequest);
            }
        });
    }

    @Override
    public Future<DBSnapshot> deleteDBSnapshotAsync(final DeleteDBSnapshotRequest deleteDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSnapshot>(){

            @Override
            public DBSnapshot call() throws Exception {
                return AmazonRDSAsyncClient.this.deleteDBSnapshot(deleteDBSnapshotRequest);
            }
        });
    }

    @Override
    public Future<OptionGroup> createOptionGroupAsync(final CreateOptionGroupRequest createOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.createOptionGroup(createOptionGroupRequest);
            }
        });
    }

    @Override
    public Future<DBInstance> modifyDBInstanceAsync(final ModifyDBInstanceRequest modifyDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBInstance>(){

            @Override
            public DBInstance call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyDBInstance(modifyDBInstanceRequest);
            }
        });
    }

    @Override
    public Future<DBSubnetGroup> createDBSubnetGroupAsync(final CreateDBSubnetGroupRequest createDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DBSubnetGroup>(){

            @Override
            public DBSubnetGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.createDBSubnetGroup(createDBSubnetGroupRequest);
            }
        });
    }

    @Override
    public Future<OptionGroup> modifyOptionGroupAsync(final ModifyOptionGroupRequest modifyOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<OptionGroup>(){

            @Override
            public OptionGroup call() throws Exception {
                return AmazonRDSAsyncClient.this.modifyOptionGroup(modifyOptionGroupRequest);
            }
        });
    }
}

