/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadMultipartPartRequestMarshaller
implements Marshaller<Request<UploadMultipartPartRequest>, UploadMultipartPartRequest> {
    @Override
    public Request<UploadMultipartPartRequest> marshall(UploadMultipartPartRequest uploadMultipartPartRequest) {
        if (uploadMultipartPartRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadMultipartPartRequest> request = new DefaultRequest<UploadMultipartPartRequest>(uploadMultipartPartRequest, "AmazonGlacier");
        String target = "Glacier.UploadMultipartPart";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.PUT);
        if (uploadMultipartPartRequest.getChecksum() != null) {
            request.addHeader("x-amz-sha256-tree-hash", StringUtils.fromString(uploadMultipartPartRequest.getChecksum()));
        }
        if (uploadMultipartPartRequest.getRange() != null) {
            request.addHeader("Content-Range", StringUtils.fromString(uploadMultipartPartRequest.getRange()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", this.getString(uploadMultipartPartRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", this.getString(uploadMultipartPartRequest.getVaultName()));
        if ((uriResourcePath = uriResourcePath.replace("{uploadId}", this.getString(uploadMultipartPartRequest.getUploadId()))).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(uploadMultipartPartRequest.getBody());
        request.addHeader("Content-Type", "binary/octet-stream");
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

