/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.QueryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRequestMarshaller
implements Marshaller<Request<QueryRequest>, QueryRequest> {
    @Override
    public Request<QueryRequest> marshall(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<QueryRequest> request = new DefaultRequest<QueryRequest>(queryRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.Query";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            Key exclusiveStartKey;
            List<String> nSList;
            List<String> sSList;
            Condition rangeKeyCondition;
            AttributeValue hashKeyValue;
            List<String> attributesToGetList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (queryRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(queryRequest.getTableName());
            }
            if ((attributesToGetList = queryRequest.getAttributesToGet()) != null && attributesToGetList.size() > 0) {
                jsonWriter.key("AttributesToGet").array();
                for (String attributesToGetListValue : attributesToGetList) {
                    jsonWriter.value(attributesToGetListValue);
                }
                jsonWriter.endArray();
            }
            if (queryRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(queryRequest.getLimit());
            }
            if (queryRequest.isConsistentRead() != null) {
                jsonWriter.key("ConsistentRead").value(queryRequest.isConsistentRead());
            }
            if (queryRequest.isCount() != null) {
                jsonWriter.key("Count").value(queryRequest.isCount());
            }
            if ((hashKeyValue = queryRequest.getHashKeyValue()) != null) {
                List<String> nSList2;
                List<String> sSList2;
                jsonWriter.key("HashKeyValue").object();
                if (hashKeyValue.getS() != null) {
                    jsonWriter.key("S").value(hashKeyValue.getS());
                }
                if (hashKeyValue.getN() != null) {
                    jsonWriter.key("N").value(hashKeyValue.getN());
                }
                if ((sSList2 = hashKeyValue.getSS()) != null && sSList2.size() > 0) {
                    jsonWriter.key("SS").array();
                    for (String sSListValue : sSList2) {
                        jsonWriter.value(sSListValue);
                    }
                    jsonWriter.endArray();
                }
                if ((nSList2 = hashKeyValue.getNS()) != null && nSList2.size() > 0) {
                    jsonWriter.key("NS").array();
                    for (String nSListValue : nSList2) {
                        jsonWriter.value(nSListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if ((rangeKeyCondition = queryRequest.getRangeKeyCondition()) != null) {
                jsonWriter.key("RangeKeyCondition").object();
                List<AttributeValue> attributeValueListList = rangeKeyCondition.getAttributeValueList();
                if (attributeValueListList != null && attributeValueListList.size() > 0) {
                    jsonWriter.key("AttributeValueList").array();
                    for (AttributeValue attributeValueListListValue : attributeValueListList) {
                        jsonWriter.object();
                        if (attributeValueListListValue.getS() != null) {
                            jsonWriter.key("S").value(attributeValueListListValue.getS());
                        }
                        if (attributeValueListListValue.getN() != null) {
                            jsonWriter.key("N").value(attributeValueListListValue.getN());
                        }
                        if ((sSList = attributeValueListListValue.getSS()) != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                jsonWriter.value(sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if ((nSList = attributeValueListListValue.getNS()) != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if (rangeKeyCondition.getComparisonOperator() != null) {
                    jsonWriter.key("ComparisonOperator").value(rangeKeyCondition.getComparisonOperator());
                }
                jsonWriter.endObject();
            }
            if (queryRequest.isScanIndexForward() != null) {
                jsonWriter.key("ScanIndexForward").value(queryRequest.isScanIndexForward());
            }
            if ((exclusiveStartKey = queryRequest.getExclusiveStartKey()) != null) {
                AttributeValue rangeKeyElement;
                jsonWriter.key("ExclusiveStartKey").object();
                AttributeValue hashKeyElement = exclusiveStartKey.getHashKeyElement();
                if (hashKeyElement != null) {
                    List<String> nSList3;
                    List<String> sSList3;
                    jsonWriter.key("HashKeyElement").object();
                    if (hashKeyElement.getS() != null) {
                        jsonWriter.key("S").value(hashKeyElement.getS());
                    }
                    if (hashKeyElement.getN() != null) {
                        jsonWriter.key("N").value(hashKeyElement.getN());
                    }
                    if ((sSList3 = hashKeyElement.getSS()) != null && sSList3.size() > 0) {
                        jsonWriter.key("SS").array();
                        for (String sSListValue : sSList3) {
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList3 = hashKeyElement.getNS()) != null && nSList3.size() > 0) {
                        jsonWriter.key("NS").array();
                        for (String nSListValue : nSList3) {
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                if ((rangeKeyElement = exclusiveStartKey.getRangeKeyElement()) != null) {
                    jsonWriter.key("RangeKeyElement").object();
                    if (rangeKeyElement.getS() != null) {
                        jsonWriter.key("S").value(rangeKeyElement.getS());
                    }
                    if (rangeKeyElement.getN() != null) {
                        jsonWriter.key("N").value(rangeKeyElement.getN());
                    }
                    if ((sSList = rangeKeyElement.getSS()) != null && sSList.size() > 0) {
                        jsonWriter.key("SS").array();
                        for (String sSListValue : sSList) {
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList = rangeKeyElement.getNS()) != null && nSList.size() > 0) {
                        jsonWriter.key("NS").array();
                        for (String nSListValue : nSList) {
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

