/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceStatusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceStatus {
    private String instanceId;
    private String availabilityZone;
    private List<InstanceStatusEvent> events;
    private InstanceState instanceState;

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public InstanceStatus withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public InstanceStatus withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public List<InstanceStatusEvent> getEvents() {
        if (this.events == null) {
            this.events = new ArrayList<InstanceStatusEvent>();
        }
        return this.events;
    }

    public void setEvents(Collection<InstanceStatusEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ArrayList<InstanceStatusEvent> eventsCopy = new ArrayList<InstanceStatusEvent>(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public InstanceStatus withEvents(InstanceStatusEvent ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<InstanceStatusEvent>(events.length));
        }
        for (InstanceStatusEvent value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public InstanceStatus withEvents(Collection<InstanceStatusEvent> events) {
        if (events == null) {
            this.events = null;
        } else {
            ArrayList<InstanceStatusEvent> eventsCopy = new ArrayList<InstanceStatusEvent>(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public InstanceState getInstanceState() {
        return this.instanceState;
    }

    public void setInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState;
    }

    public InstanceStatus withInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId != null) {
            sb.append("InstanceId: " + this.instanceId + ", ");
        }
        if (this.availabilityZone != null) {
            sb.append("AvailabilityZone: " + this.availabilityZone + ", ");
        }
        if (this.events != null) {
            sb.append("Events: " + this.events + ", ");
        }
        if (this.instanceState != null) {
            sb.append("InstanceState: " + this.instanceState + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : ((Object)this.getEvents()).hashCode());
        hashCode = 31 * hashCode + (this.getInstanceState() == null ? 0 : this.getInstanceState().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStatus)) {
            return false;
        }
        InstanceStatus other = (InstanceStatus)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !((Object)other.getEvents()).equals(this.getEvents())) {
            return false;
        }
        if (other.getInstanceState() == null ^ this.getInstanceState() == null) {
            return false;
        }
        return other.getInstanceState() == null || other.getInstanceState().equals(this.getInstanceState());
    }
}

